/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import com.google.common.base.Joiner;
import com.lancedb.lance.namespace.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class CommonUtil {
    private CommonUtil() {
    }

    public static String formatCurrentStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return CommonUtil.formatStackTrace(stackTrace);
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(stackTrace, 1, stackTrace.length));
    }

    public static String makeQualified(String absolutePath) {
        try {
            String uriString = absolutePath.startsWith("/") ? "file://" + absolutePath : absolutePath;
            URI uri = new URI(uriString);
            ValidationUtil.checkArgument(uri.isAbsolute(), "Couldn't parse %s because it is not absolute.", absolutePath);
            String scheme = uri.getScheme();
            String authority = uri.getAuthority() == null ? "" : uri.getAuthority();
            String path = uri.getPath();
            return String.format("%s://%s%s", scheme, authority, path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid path %s", absolutePath), e);
        }
    }
}

