/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance;

import java.lang.reflect.Constructor;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.gravitino.Config;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.auxiliary.GravitinoAuxiliaryService;
import org.apache.gravitino.lance.common.config.LanceConfig;
import org.apache.gravitino.lance.common.ops.LanceNamespaceBackend;
import org.apache.gravitino.lance.common.ops.NamespaceWrapper;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.server.web.HttpServerMetricsSource;
import org.apache.gravitino.server.web.JettyServer;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanceRESTService
implements GravitinoAuxiliaryService {
    private static final Logger LOG = LoggerFactory.getLogger(LanceRESTService.class);
    public static final String SERVICE_NAME = "lance-rest";
    public static final String LANCE_SPEC = "/lance/*";
    private static final String LANCE_REST_SPEC_PACKAGE = "org.apache.gravitino.lance.service.rest";
    private JettyServer server;
    private NamespaceWrapper lanceNamespace;

    public String shortName() {
        return SERVICE_NAME;
    }

    public void serviceInit(Map<String, String> properties) {
        LanceConfig lanceConfig = new LanceConfig(properties);
        JettyServerConfig serverConfig = JettyServerConfig.fromConfig((Config)lanceConfig);
        this.server = new JettyServer();
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        this.server.initialize(serverConfig, SERVICE_NAME, false);
        this.lanceNamespace = this.loadNamespaceImpl(lanceConfig);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register(JacksonFeature.class);
        resourceConfig.packages(new String[]{LANCE_REST_SPEC_PACKAGE});
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(LanceRESTService.this.lanceNamespace).to(NamespaceWrapper.class).ranked(1);
            }
        });
        HttpServerMetricsSource httpServerMetricsSource = new HttpServerMetricsSource("lance-rest-server", resourceConfig, this.server);
        metricsSystem.register((MetricsSource)httpServerMetricsSource);
        ServletContainer container = new ServletContainer(resourceConfig);
        this.server.addServlet((Servlet)container, LANCE_SPEC);
        this.server.addCustomFilters(LANCE_SPEC);
        this.server.addSystemFilters(LANCE_SPEC);
        LOG.info("Initialized Lance REST service for backend {}", (Object)lanceConfig.getNamespaceBackend());
    }

    public void serviceStart() {
        if (this.server != null) {
            this.server.start();
            LOG.info("Lance REST service started");
        }
    }

    public void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            LOG.info("Lance REST service stopped");
        }
        if (this.lanceNamespace != null) {
            this.lanceNamespace.close();
        }
    }

    public void join() {
        if (this.server != null) {
            this.server.join();
        }
    }

    private NamespaceWrapper loadNamespaceImpl(LanceConfig lanceConfig) {
        String backendType = (String)lanceConfig.get(LanceConfig.NAMESPACE_BACKEND);
        LanceNamespaceBackend lanceNamespaceBackend = LanceNamespaceBackend.fromType((String)backendType);
        try {
            Constructor constructor = lanceNamespaceBackend.getWrapperClass().getConstructor(LanceConfig.class);
            return (NamespaceWrapper)constructor.newInstance(lanceConfig);
        }
        catch (Exception e) {
            LOG.error("Error loading namespace implementation for backend type: {}", (Object)backendType, (Object)e);
            throw new RuntimeException("Failed to load namespace implementation", e);
        }
    }
}

