/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.GroupRoleRelPO;
import org.apache.ibatis.annotations.Param;

public class GroupRoleRelBaseSQLProvider {
    public String batchInsertGroupRoleRel(@Param(value="groupRoleRels") List<GroupRoleRelPO> groupRoleRelPOS) {
        return "<script>INSERT INTO group_role_rel (group_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='groupRoleRels' item='item' separator=','>(#{item.groupId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach></script>";
    }

    public String batchInsertGroupRoleRelOnDuplicateKeyUpdate(@Param(value="groupRoleRels") List<GroupRoleRelPO> groupRoleRelPOS) {
        return "<script>INSERT INTO group_role_rel (group_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='groupRoleRels' item='item' separator=','>(#{item.groupId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach> ON DUPLICATE KEY UPDATE group_id = VALUES(group_id), role_id = VALUES(role_id), audit_info = VALUES(audit_info), current_version = VALUES(current_version), last_version = VALUES(last_version), deleted_at = VALUES(deleted_at)</script>";
    }

    public String softDeleteGroupRoleRelByGroupId(@Param(value="groupId") Long groupId) {
        return "UPDATE group_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE group_id = #{groupId} AND deleted_at = 0";
    }

    public String softDeleteGroupRoleRelByGroupAndRoles(@Param(value="groupId") Long groupId, @Param(value="roleIds") List<Long> roleIds) {
        return "<script>UPDATE group_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE group_id = #{groupId} AND role_id in (<foreach collection='roleIds' item='roleId' separator=','>#{roleId}</foreach>) AND deleted_at = 0</script>";
    }

    public String softDeleteGroupRoleRelByMetalakeId(Long metalakeId) {
        return "UPDATE group_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE group_id IN (SELECT group_id FROM group_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteGroupRoleRelByRoleId(Long roleId) {
        return "UPDATE group_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    public String deleteGroupRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM group_role_rel WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

