/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Decimal;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.catalog.jdbc.JdbcColumnDefaultValueConverter;

public class MysqlColumnDefaultValueConverter
extends JdbcColumnDefaultValueConverter {
    @Override
    public Expression toGravitino(Type type, String columnDefaultValue, boolean nullable) {
        if (columnDefaultValue == null) {
            return nullable ? Literals.NULL : Column.DEFAULT_VALUE_NOT_SET;
        }
        if (columnDefaultValue.equalsIgnoreCase("NULL")) {
            return Literals.NULL;
        }
        try {
            switch (type.name()) {
                case BYTE: {
                    return Literals.byteLiteral((Byte)Byte.valueOf(columnDefaultValue));
                }
                case SHORT: {
                    return Literals.shortLiteral((Short)Short.valueOf(columnDefaultValue));
                }
                case INTEGER: {
                    return Literals.integerLiteral((Integer)Integer.valueOf(columnDefaultValue));
                }
                case LONG: {
                    return Literals.longLiteral((Long)Long.valueOf(columnDefaultValue));
                }
                case FLOAT: {
                    return Literals.floatLiteral((Float)Float.valueOf(columnDefaultValue));
                }
                case DOUBLE: {
                    return Literals.doubleLiteral((Double)Double.valueOf(columnDefaultValue));
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)type;
                    return Literals.decimalLiteral((Decimal)Decimal.of((String)columnDefaultValue, (int)decimalType.precision(), (int)decimalType.scale()));
                }
                case DATE: {
                    return Literals.dateLiteral((LocalDate)LocalDate.parse(columnDefaultValue, DATE_FORMATTER));
                }
                case TIME: {
                    return Literals.timeLiteral((LocalTime)LocalTime.parse(columnDefaultValue, TIME_FORMATTER));
                }
                case TIMESTAMP: {
                    if ("CURRENT_TIMESTAMP".equalsIgnoreCase(columnDefaultValue)) {
                        return Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP;
                    }
                    try {
                        return Literals.timestampLiteral((LocalDateTime)LocalDateTime.parse(columnDefaultValue, DATE_TIME_FORMATTER));
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalArgumentException(String.format("Unable to parse datetime value: %s", columnDefaultValue));
                    }
                }
                case FIXEDCHAR: {
                    Types.FixedCharType fixedCharType = (Types.FixedCharType)type;
                    return Literals.of((Object)columnDefaultValue, (Type)Types.FixedCharType.of((int)fixedCharType.length()));
                }
                case VARCHAR: 
                case STRING: {
                    return Literals.stringLiteral((String)columnDefaultValue);
                }
            }
            throw new IllegalArgumentException("This Type not support default value");
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalidate default value %s for %s type. %s", columnDefaultValue, type.name(), e.getMessage()));
        }
    }
}

