/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.LogNormal;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.WienerProcess;

public final class GeometricBrownianMotion
extends AbstractProcess<LogNormal> {
    private static final WienerProcess GENERATOR = new WienerProcess();
    private final double myDiffusionFunction;
    private final double myLocalDrift;

    public static GeometricBrownianMotion estimate(Access1D<?> seriesOfSamples, double samplePeriod) {
        int tmpSizeMinusOne = (int)(seriesOfSamples.count() - 1L);
        Structure1D tmpLogDiffSeries = Array1D.PRIMITIVE64.makeZero(tmpSizeMinusOne);
        for (int i = 0; i < tmpSizeMinusOne; ++i) {
            ((Array1D)tmpLogDiffSeries).set((long)i, PrimitiveFunction.LOG.invoke(seriesOfSamples.doubleValue(i + 1) / seriesOfSamples.doubleValue(i)));
        }
        SampleSet tmpSampleSet = SampleSet.wrap(tmpLogDiffSeries);
        double tmpExp = tmpSampleSet.getMean();
        double tmpVar = tmpSampleSet.getVariance();
        double tmpDiff = PrimitiveFunction.SQRT.invoke(tmpVar / samplePeriod);
        double tmpDrift = tmpExp / samplePeriod + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(seriesOfSamples.doubleValue(0L));
        return retVal;
    }

    public static GeometricBrownianMotion make(double expected, double variance) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, expected, variance, PrimitiveMath.ONE);
    }

    public static GeometricBrownianMotion make(double expected, double variance, double horizon) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, expected, variance, horizon);
    }

    public static GeometricBrownianMotion make(double initialValue, double expectedFutureValue, double aVariance, double aHorizon) {
        double tmpDrift = PrimitiveFunction.LOG.invoke(expectedFutureValue / initialValue) / aHorizon;
        double tmpDiff = PrimitiveFunction.SQRT.invoke(PrimitiveFunction.LOG1P.invoke(aVariance / (expectedFutureValue * expectedFutureValue)) / aHorizon);
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(initialValue);
        return retVal;
    }

    public GeometricBrownianMotion(double localDrift, double diffusionFunction) {
        this.setValue(PrimitiveMath.ONE);
        this.myLocalDrift = localDrift;
        this.myDiffusionFunction = diffusionFunction;
    }

    private GeometricBrownianMotion() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    }

    public GeometricBrownianMotion convert(double convertionFactor) {
        double tmpDrift = this.myLocalDrift * convertionFactor;
        double tmpDiff = this.myDiffusionFunction * PrimitiveFunction.SQRT.invoke(convertionFactor);
        return new GeometricBrownianMotion(tmpDrift, tmpDiff);
    }

    @Override
    public LogNormal getDistribution(double evaluationPoint) {
        double tmpVar = this.getDistributionVariance(evaluationPoint);
        double tmpLocation = this.getDistributionLocation(evaluationPoint, tmpVar);
        double tmpScale = PrimitiveFunction.SQRT.invoke(tmpVar);
        return new LogNormal(tmpLocation, tmpScale);
    }

    private final double getDistributionLocation(double stepSize, double variance) {
        return PrimitiveFunction.LOG.invoke(this.getValue()) + this.myLocalDrift * stepSize - PrimitiveMath.HALF * variance;
    }

    private final double getDistributionVariance(double stepSize) {
        return this.myDiffusionFunction * this.myDiffusionFunction * stepSize;
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.getNormalisedRandomIncrement();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double tmpDetPart = (this.myLocalDrift - this.myDiffusionFunction * this.myDiffusionFunction / PrimitiveMath.TWO) * stepSize;
        double tmpRandPart = this.myDiffusionFunction * PrimitiveFunction.SQRT.invoke(stepSize) * normalisedRandomIncrement;
        double retVal = currentValue * PrimitiveFunction.EXP.invoke(tmpDetPart + tmpRandPart);
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.getValue() * PrimitiveFunction.EXP.invoke(this.myLocalDrift * stepSize);
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        double tmpVar = this.getDistributionVariance(stepSize);
        double tmpLocation = this.getDistributionLocation(stepSize, tmpVar);
        double tmpScale = PrimitiveFunction.SQRT.invoke(tmpVar);
        return PrimitiveFunction.EXP.invoke(tmpLocation - tmpScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(confidence));
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveFunction.SQRT.invoke(this.getVariance(stepSize));
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        double tmpVar = this.getDistributionVariance(stepSize);
        double tmpLocation = this.getDistributionLocation(stepSize, tmpVar);
        double tmpScale = PrimitiveFunction.SQRT.invoke(tmpVar);
        return PrimitiveFunction.EXP.invoke(tmpLocation + tmpScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(confidence));
    }

    @Override
    double getVariance(double stepSize) {
        return this.getValue() * this.getValue() * PrimitiveFunction.EXP.invoke(PrimitiveMath.TWO * this.myLocalDrift * stepSize) * PrimitiveFunction.EXPM1.invoke(this.getDistributionVariance(stepSize));
    }
}

