/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsApacheHttpExpect100Exception;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedApacheHttpConnection;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class AbfsManagedHttpRequestExecutor
extends HttpRequestExecutor {
    public AbfsManagedHttpRequestExecutor(int expect100WaitTimeout) {
        super(expect100WaitTimeout);
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (context instanceof AbfsManagedHttpClientContext && conn instanceof AbfsManagedApacheHttpConnection) {
            ((AbfsManagedApacheHttpConnection)conn).setManagedHttpContext((AbfsManagedHttpClientContext)context);
        }
        return super.execute(request, conn, context);
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        HttpClientConnection inteceptedConnection = context instanceof AbfsManagedHttpClientContext ? ((AbfsManagedHttpClientContext)context).interceptConnectionActivity(conn) : conn;
        HttpResponse res = super.doSendRequest(request, inteceptedConnection, context);
        if (request != null && request.containsHeader("Expect") && res != null) {
            throw new AbfsApacheHttpExpect100Exception(res);
        }
        return res;
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        HttpClientConnection interceptedConnection = context instanceof AbfsManagedHttpClientContext ? ((AbfsManagedHttpClientContext)context).interceptConnectionActivity(conn) : conn;
        return super.doReceiveResponse(request, interceptedConnection, context);
    }
}

