/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterUserProtocol
implements RefreshUserMappingsProtocol,
GetUserMappingsProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterUserProtocol.class);
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public RouterUserProtocol(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcServer.getNamenodeResolver();
    }

    public void refreshUserToGroupsMappings() throws IOException {
        LOG.debug("Refresh user groups mapping in Router.");
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        if (nss.isEmpty()) {
            Groups.getUserToGroupsMappingService().refresh();
        } else {
            RemoteMethod method = new RemoteMethod(RefreshUserMappingsProtocol.class, "refreshUserToGroupsMappings");
            this.rpcClient.invokeConcurrent(nss, method);
        }
    }

    public void refreshSuperUserGroupsConfiguration() throws IOException {
        LOG.debug("Refresh superuser groups configuration in Router.");
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        if (nss.isEmpty()) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        } else {
            RemoteMethod method = new RemoteMethod(RefreshUserMappingsProtocol.class, "refreshSuperUserGroupsConfiguration");
            this.rpcClient.invokeConcurrent(nss, method);
        }
    }

    public String[] getGroupsForUser(String user) throws IOException {
        LOG.debug("Getting groups for user {}", (Object)user);
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        if (nss.isEmpty()) {
            return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
        }
        RemoteMethod method = new RemoteMethod(GetUserMappingsProtocol.class, "getGroupsForUser", new Class[]{String.class}, user);
        Map<FederationNamespaceInfo, String[]> results = this.rpcClient.invokeConcurrent(nss, method, String[].class);
        return RouterRpcServer.merge(results, String.class);
    }
}

