/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLSecretManagerRetriableHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLSecretManagerRetriableHandlerImpl
implements SQLSecretManagerRetriableHandler {
    public static final String MAX_RETRIES = "sql-dt-secret-manager.max-retries";
    public static final int MAX_RETRIES_DEFAULT = 0;
    public static final String RETRY_SLEEP_TIME_MS = "sql-dt-secret-manager.retry-sleep-time-ms";
    public static final long RETRY_SLEEP_TIME_MS_DEFAULT = 100L;
    private static final Logger LOG = LoggerFactory.getLogger(SQLSecretManagerRetriableHandlerImpl.class);

    SQLSecretManagerRetriableHandlerImpl() {
    }

    static SQLSecretManagerRetriableHandler getInstance(Configuration conf) {
        return SQLSecretManagerRetriableHandlerImpl.getInstance(conf, new SQLSecretManagerRetriableHandlerImpl());
    }

    static SQLSecretManagerRetriableHandler getInstance(Configuration conf, SQLSecretManagerRetriableHandlerImpl retryHandler) {
        RetryPolicy basePolicy = RetryPolicies.exponentialBackoffRetry((int)conf.getInt(MAX_RETRIES, 0), (long)conf.getLong(RETRY_SLEEP_TIME_MS, 100L), (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<SQLSecretManagerRetriableException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<SQLSecretManagerRetriableException>, RetryPolicy>();
        exceptionToPolicyMap.put(SQLSecretManagerRetriableException.class, basePolicy);
        RetryPolicy retryPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        return (SQLSecretManagerRetriableHandler)RetryProxy.create(SQLSecretManagerRetriableHandler.class, (Object)retryHandler, (RetryPolicy)retryPolicy);
    }

    @Override
    public void execute(SQLSecretManagerRetriableHandler.SQLCommandVoid command) throws SQLException {
        try {
            command.doCall();
        }
        catch (SQLException e) {
            LOG.warn("Failed to execute SQL command", (Throwable)e);
            throw new SQLSecretManagerRetriableException(e);
        }
    }

    @Override
    public <T> T execute(SQLSecretManagerRetriableHandler.SQLCommand<T> command) throws SQLException {
        try {
            return command.doCall();
        }
        catch (SQLException e) {
            LOG.warn("Failed to execute SQL command", (Throwable)e);
            throw new SQLSecretManagerRetriableException(e);
        }
    }

    static class SQLSecretManagerRetriableException
    extends SQLException {
        SQLSecretManagerRetriableException(Throwable cause) {
            super(cause);
        }
    }
}

