/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestRollbackSCP {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRollbackSCP.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final AtomicBoolean INJECTED = new AtomicBoolean(false);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numDataNodes(3).numRegionServers(3).masterClass(HMasterForTest.class).build());
        UTIL.createMultiRegionTable(TABLE_NAME, FAMILY);
        UTIL.waitTableAvailable(TABLE_NAME);
        UTIL.getAdmin().balance(BalanceRequest.newBuilder().setIgnoreRegionsInTransition(true).build());
        UTIL.waitUntilNoRegionsInTransition();
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        UTIL.ensureSomeNonStoppedRegionServersAvailable(2);
    }

    private ServerCrashProcedure getSCPForServer(ServerName serverName) throws IOException {
        return UTIL.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).map(p -> (ServerCrashProcedure)p).filter(p -> p.getServerName().equals((Object)serverName)).findFirst().orElse(null);
    }

    private Matcher<Procedure<MasterProcedureEnv>> subProcOf(final Procedure<MasterProcedureEnv> proc) {
        return new BaseMatcher<Procedure<MasterProcedureEnv>>(){

            public boolean matches(Object item) {
                if (!(item instanceof Procedure)) {
                    return false;
                }
                Procedure p = (Procedure)item;
                return p.hasParent() && p.getRootProcId() == proc.getProcId();
            }

            public void describeTo(Description description) {
                description.appendText("sub procedure of(").appendValue((Object)proc).appendText(")");
            }
        };
    }

    @Test
    public void testFailAndRollback() throws Exception {
        HRegionServer rsWithMeta = UTIL.getRSForFirstRegionInTable(TableName.META_TABLE_NAME);
        UTIL.getMiniHBaseCluster().killRegionServer(rsWithMeta.getServerName());
        UTIL.waitFor(15000L, () -> this.getSCPForServer(rsWithMeta.getServerName()) != null);
        ServerCrashProcedure scp = this.getSCPForServer(rsWithMeta.getServerName());
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(30000L, () -> !procExec.isRunning());
        while (scp.getState() != ProcedureProtos.ProcedureState.FAILED || !procExec.isRunning()) {
            MasterProcedureTestingUtility.restartMasterProcedureExecutor((ProcedureExecutor<MasterProcedureEnv>)procExec);
            ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (Procedure)scp);
        }
        Assert.assertEquals((Object)scp.getState(), (Object)ProcedureProtos.ProcedureState.FAILED);
        MatcherAssert.assertThat((Object)scp.getException().getMessage(), (Matcher)Matchers.containsString((String)"inject code bug"));
        MatcherAssert.assertThat((Object)procExec.getProcedures(), (Matcher)Matchers.everyItem((Matcher)Matchers.not(this.subProcOf((Procedure<MasterProcedureEnv>)scp))));
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        void persistToMeta(RegionStateNode regionNode) throws IOException {
            Procedure p;
            TransitRegionStateProcedure proc = regionNode.getProcedure();
            if (!regionNode.getRegionInfo().isMetaRegion() && proc.hasParent() && (p = this.getMaster().getMasterProcedureExecutor().getProcedure(proc.getRootProcId())) instanceof ServerCrashProcedure) {
                if (INJECTED.compareAndSet(false, true)) {
                    ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdateInRollback((ProcedureExecutor)this.getMaster().getMasterProcedureExecutor(), (boolean)true);
                }
                throw new RuntimeException("inject code bug");
            }
            super.persistToMeta(regionNode);
        }
    }
}

