/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRpcLogDetails {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcLogDetails.class);
    private final ClientProtos.Scan scan = ClientProtos.Scan.newBuilder().setStartRow(ByteString.copyFrom((byte[])Bytes.toBytes((String)"abc"))).setStopRow(ByteString.copyFrom((byte[])Bytes.toBytes((String)"xyz"))).build();
    private final ClientProtos.Scan otherScan = ClientProtos.Scan.newBuilder().setStartRow(ByteString.copyFrom((byte[])Bytes.toBytes((String)"def"))).setStopRow(ByteString.copyFrom((byte[])Bytes.toBytes((String)"uvw"))).build();
    private final ClientProtos.ScanRequest scanRequest = ClientProtos.ScanRequest.newBuilder((ClientProtos.ScanRequest)ClientProtos.ScanRequest.getDefaultInstance()).setScan(this.scan).build();
    private final ClientProtos.ScanRequest otherScanRequest = ClientProtos.ScanRequest.newBuilder((ClientProtos.ScanRequest)ClientProtos.ScanRequest.getDefaultInstance()).setScan(this.otherScan).build();

    @Test
    public void itDeepCopiesRpcLogDetailsParams() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.scanRequest.toByteArray().length);
        CodedInputStream cis = UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer).newCodedInput();
        cis.enableAliasing(true);
        buffer.put(this.scanRequest.toByteArray());
        ClientProtos.ScanRequest.Builder messageBuilder = ClientProtos.ScanRequest.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)messageBuilder, (CodedInputStream)cis, (int)buffer.capacity());
        Message message = messageBuilder.build();
        RpcLogDetails rpcLogDetails = new RpcLogDetails(TestRpcLogDetails.getRpcCall(message), message, null, 0L, 0L, 0L, null, true, false);
        ClientProtos.Scan logScan = ((ClientProtos.ScanRequest)rpcLogDetails.getParam()).getScan();
        Assert.assertEquals((Object)logScan, (Object)this.scan);
        Assert.assertFalse((boolean)Arrays.equals(this.scanRequest.toByteArray(), this.otherScanRequest.toByteArray()));
        buffer.position(0);
        buffer.put(this.otherScanRequest.toByteArray(), 0, this.otherScanRequest.toByteArray().length);
        Assert.assertArrayEquals((byte[])this.otherScanRequest.toByteArray(), (byte[])buffer.array());
        Assert.assertEquals((Object)logScan, (Object)this.scan);
    }

    private static RpcCall getRpcCall(final Message message) {
        RpcCall rpcCall = new RpcCall(){

            public BlockingService getService() {
                return null;
            }

            public Descriptors.MethodDescriptor getMethod() {
                return null;
            }

            public Message getParam() {
                return message;
            }

            public CellScanner getCellScanner() {
                return null;
            }

            public long getReceiveTime() {
                return 0L;
            }

            public long getStartTime() {
                return 0L;
            }

            public void setStartTime(long startTime) {
            }

            public int getTimeout() {
                return 0;
            }

            public int getPriority() {
                return 0;
            }

            public long getDeadline() {
                return 0L;
            }

            public long getSize() {
                return 0L;
            }

            public RPCProtos.RequestHeader getHeader() {
                return null;
            }

            public Map<String, byte[]> getConnectionAttributes() {
                return Collections.emptyMap();
            }

            public Map<String, byte[]> getRequestAttributes() {
                return Collections.emptyMap();
            }

            public byte[] getRequestAttribute(String key) {
                return null;
            }

            public int getRemotePort() {
                return 0;
            }

            public void setResponse(Message param, CellScanner cells, Throwable errorThrowable, String error) {
            }

            public void sendResponseIfReady() throws IOException {
            }

            public void cleanup() {
            }

            public String toShortString() {
                return null;
            }

            public long disconnectSince() {
                return 0L;
            }

            public boolean isClientCellBlockSupported() {
                return false;
            }

            public Optional<User> getRequestUser() {
                return null;
            }

            public Optional<X509Certificate[]> getClientCertificateChain() {
                return Optional.empty();
            }

            public InetAddress getRemoteAddress() {
                return null;
            }

            public HBaseProtos.VersionInfo getClientVersionInfo() {
                return null;
            }

            public void setCallBack(RpcCallback callback) {
            }

            public boolean isRetryImmediatelySupported() {
                return false;
            }

            public long getResponseCellSize() {
                return 0L;
            }

            public void incrementResponseCellSize(long cellSize) {
            }

            public long getBlockBytesScanned() {
                return 0L;
            }

            public void incrementBlockBytesScanned(long blockSize) {
            }

            public long getResponseExceptionSize() {
                return 0L;
            }

            public void incrementResponseExceptionSize(long exceptionSize) {
            }
        };
        return rpcCall;
    }
}

