/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestWALEntryStreamCompressionReset {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEntryStreamCompressionReset.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"reset");
    private static RegionInfo REGION_INFO = RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build();
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static MultiVersionConcurrencyControl MVCC = new MultiVersionConcurrencyControl();
    private static NavigableMap<byte[], Integer> SCOPE;
    private static String GROUP_ID;
    private static FileSystem FS;
    private static ReplicationSource SOURCE;
    private static MetricsSource METRICS_SOURCE;
    private static ReplicationSourceLogQueue LOG_QUEUE;
    private static Path TEMPLATE_WAL_FILE;
    private static int END_OFFSET_OF_WAL_ENTRIES;
    private static Path WAL_FILE;
    private static volatile long WAL_LENGTH;
    private static ReplicationSourceWALReader READER;

    private static Pair<Path, Long> generateWAL() throws Exception {
        Path path = UTIL.getDataTestDir("wal");
        ProtobufLogWriter writer = new ProtobufLogWriter();
        writer.init(FS, path, UTIL.getConfiguration(), false, FS.getDefaultBlockSize(path), null);
        for (int i = 0; i < 127; ++i) {
            WALEdit edit = new WALEdit();
            edit.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)i)).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)("qualifier-" + i))).setValue(Bytes.toBytes((String)("v-" + i))).build());
            writer.append(new WAL.Entry(new WALKeyImpl(REGION_INFO.getEncodedNameAsBytes(), TABLE_NAME, EnvironmentEdgeManager.currentTime(), MVCC, SCOPE), edit));
        }
        WALEdit edit2 = new WALEdit();
        edit2.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)-1)).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)"qualifier")).setValue(Bytes.toBytes((String)"vv")).build());
        edit2.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)-1)).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)"qualifier-1")).setValue(Bytes.toBytes((String)"vvv")).build());
        writer.append(new WAL.Entry(new WALKeyImpl(REGION_INFO.getEncodedNameAsBytes(), TABLE_NAME, EnvironmentEdgeManager.currentTime(), MVCC, SCOPE), edit2));
        writer.sync(false);
        long offset = writer.getSyncedLength();
        writer.close();
        return Pair.newPair((Object)path, (Object)offset);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        FS = UTIL.getTestFileSystem();
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        FS.mkdirs(UTIL.getDataTestDir());
        Pair<Path, Long> pair = TestWALEntryStreamCompressionReset.generateWAL();
        TEMPLATE_WAL_FILE = (Path)pair.getFirst();
        END_OFFSET_OF_WAL_ENTRIES = ((Long)pair.getSecond()).intValue();
        WAL_FILE = UTIL.getDataTestDir("rep_source");
        METRICS_SOURCE = new MetricsSource("reset");
        SOURCE = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)SOURCE.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)SOURCE.getWALFileLengthProvider()).thenReturn(p -> OptionalLong.of(WAL_LENGTH));
        Mockito.when((Object)SOURCE.getServerWALsBelongTo()).thenReturn((Object)ServerName.valueOf((String)"localhost", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)SOURCE.getSourceMetrics()).thenReturn((Object)METRICS_SOURCE);
        ReplicationSourceManager rsm = new ReplicationSourceManager(null, null, conf, null, null, null, null, null, null, (MetricsReplicationGlobalSourceSource)Mockito.mock(MetricsReplicationGlobalSourceSource.class));
        Mockito.when((Object)SOURCE.getSourceManager()).thenReturn((Object)rsm);
        LOG_QUEUE = new ReplicationSourceLogQueue(conf, METRICS_SOURCE, SOURCE);
        LOG_QUEUE.enqueueLog(WAL_FILE, GROUP_ID);
        READER = new ReplicationSourceWALReader(FS, conf, LOG_QUEUE, 0L, e -> e, SOURCE, GROUP_ID);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        READER.setReaderRunning(false);
        READER.join();
        UTIL.cleanupTestDir();
    }

    private void test(byte[] content, FSDataOutputStream out) throws Exception {
        WAL.Entry entry;
        WALEntryBatch batch;
        out.write(content, 0, END_OFFSET_OF_WAL_ENTRIES - 15);
        out.hflush();
        WAL_LENGTH = END_OFFSET_OF_WAL_ENTRIES - 15;
        READER.start();
        ArrayList entries = new ArrayList();
        while ((batch = READER.poll(1000L)) != null) {
            entries.addAll(batch.getWalEntries());
        }
        Assert.assertEquals((long)127L, (long)entries.size());
        for (int i = 0; i < 127; ++i) {
            entry = (WAL.Entry)entries.get(i);
            Assert.assertEquals((long)1L, (long)entry.getEdit().size());
            Cell cell = (Cell)entry.getEdit().getCells().get(0);
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()));
            Assert.assertEquals((Object)Bytes.toString((byte[])FAMILY), (Object)Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
            Assert.assertEquals((Object)("qualifier-" + i), (Object)Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            Assert.assertEquals((Object)("v-" + i), (Object)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
        Assert.assertNull((Object)READER.poll(1000L));
        out.write(content, END_OFFSET_OF_WAL_ENTRIES - 15, 15);
        out.hflush();
        WAL_LENGTH = END_OFFSET_OF_WAL_ENTRIES;
        batch = READER.poll(10000L);
        Assert.assertEquals((long)1L, (long)batch.getNbEntries());
        entry = (WAL.Entry)batch.getWalEntries().get(0);
        Assert.assertEquals((long)2L, (long)entry.getEdit().size());
        Cell cell2 = (Cell)entry.getEdit().getCells().get(0);
        Assert.assertEquals((long)-1L, (long)Bytes.toInt((byte[])cell2.getRowArray(), (int)cell2.getRowOffset()));
        Assert.assertEquals((Object)Bytes.toString((byte[])FAMILY), (Object)Bytes.toString((byte[])cell2.getFamilyArray(), (int)cell2.getFamilyOffset(), (int)cell2.getFamilyLength()));
        Assert.assertEquals((Object)"qualifier", (Object)Bytes.toString((byte[])cell2.getQualifierArray(), (int)cell2.getQualifierOffset(), (int)cell2.getQualifierLength()));
        Assert.assertEquals((Object)"vv", (Object)Bytes.toString((byte[])cell2.getValueArray(), (int)cell2.getValueOffset(), (int)cell2.getValueLength()));
        Cell cell3 = (Cell)entry.getEdit().getCells().get(1);
        Assert.assertEquals((long)-1L, (long)Bytes.toInt((byte[])cell3.getRowArray(), (int)cell3.getRowOffset()));
        Assert.assertEquals((Object)Bytes.toString((byte[])FAMILY), (Object)Bytes.toString((byte[])cell3.getFamilyArray(), (int)cell3.getFamilyOffset(), (int)cell3.getFamilyLength()));
        Assert.assertEquals((Object)"qualifier-1", (Object)Bytes.toString((byte[])cell3.getQualifierArray(), (int)cell3.getQualifierOffset(), (int)cell3.getQualifierLength()));
        Assert.assertEquals((Object)"vvv", (Object)Bytes.toString((byte[])cell3.getValueArray(), (int)cell3.getValueOffset(), (int)cell3.getValueLength()));
    }

    @Test
    public void testReset() throws Exception {
        byte[] content;
        try (FSDataInputStream in = FS.open(TEMPLATE_WAL_FILE);){
            content = ByteStreams.toByteArray((InputStream)in);
        }
        var3_2 = null;
        try (FSDataOutputStream out = FS.create(WAL_FILE);){
            this.test(content, out);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    static {
        GROUP_ID = "group";
    }
}

