/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionCountSkewCostFunction
extends CostFunction {
    static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.regionCountCost";
    static final float DEFAULT_REGION_COUNT_SKEW_COST = 500.0f;
    private final DoubleArrayCost cost = new DoubleArrayCost();

    RegionCountSkewCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 500.0f));
    }

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        this.cost.prepare(cluster.numServers);
        this.cost.applyCostsChange(costs -> {
            for (int i = 0; i < cluster.numServers; ++i) {
                costs[i] = cluster.regionsPerServer[i].length;
            }
        });
    }

    @Override
    protected double cost() {
        return this.cost.cost();
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        this.cost.applyCostsChange(costs -> {
            costs[oldServer] = this.cluster.regionsPerServer[oldServer].length;
            costs[newServer] = this.cluster.regionsPerServer[newServer].length;
        });
    }

    @Override
    public final void updateWeight(double[] weights) {
        int n = StochasticLoadBalancer.GeneratorType.LOAD.ordinal();
        weights[n] = weights[n] + this.cost();
    }
}

