/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.namequeues.DisruptorExceptionHandler;
import org.apache.hadoop.hbase.namequeues.LogEventHandler;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.BlockingWaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.RingBuffer;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.WaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.Disruptor;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.ProducerType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamedQueueRecorder {
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private static volatile NamedQueueRecorder namedQueueRecorder;
    private static boolean isInit;
    private static final Object LOCK;

    private NamedQueueRecorder(Configuration conf) {
        String hostingThreadName = Thread.currentThread().getName();
        int eventCount = conf.getInt("hbase.namedqueue.ringbuffer.size", 1024);
        this.disruptor = new Disruptor<RingBufferEnvelope>(RingBufferEnvelope::new, this.getEventCount(eventCount), new ThreadFactoryBuilder().setNameFormat(hostingThreadName + ".slowlog.append-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler(new DisruptorExceptionHandler());
        this.logEventHandler = new LogEventHandler(conf);
        this.disruptor.handleEventsWith(this.logEventHandler);
        this.disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="singleton pattern")
    public static NamedQueueRecorder getInstance(Configuration conf) {
        if (namedQueueRecorder != null) {
            return namedQueueRecorder;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!isInit) {
                namedQueueRecorder = new NamedQueueRecorder(conf);
                isInit = true;
            }
        }
        return namedQueueRecorder;
    }

    private int getEventCount(int eventCount) {
        Preconditions.checkArgument(eventCount >= 0, "hbase.namedqueue.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(eventCount);
        if (floor == eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.logEventHandler.getNamedQueueRecords(request);
    }

    public boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.logEventHandler.clearNamedQueue(namedQueueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(NamedQueuePayload namedQueuePayload) {
        RingBuffer<RingBufferEnvelope> ringBuffer = this.disruptor.getRingBuffer();
        long seqId = ringBuffer.next();
        try {
            ringBuffer.get(seqId).load(namedQueuePayload);
        }
        finally {
            ringBuffer.publish(seqId);
        }
    }

    public void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        if (this.logEventHandler != null) {
            this.logEventHandler.persistAll(namedQueueEvent);
        }
    }

    static {
        isInit = false;
        LOCK = new Object();
    }
}

