/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.random.GaussianRandomGenerator;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.StoreFileListGenerator;

class GaussianFileListGenerator
extends StoreFileListGenerator {
    GaussianFileListGenerator() {
    }

    @Override
    public Iterator<List<HStoreFile>> iterator() {
        return new Iterator<List<HStoreFile>>(){
            private GaussianRandomGenerator gen = new GaussianRandomGenerator((RandomGenerator)new MersenneTwister());
            private int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < 10;
            }

            @Override
            public List<HStoreFile> next() {
                ++this.count;
                ArrayList<HStoreFile> files = new ArrayList<HStoreFile>(1000);
                for (int i = 0; i < 1000; ++i) {
                    files.add(GaussianFileListGenerator.this.createMockStoreFile((int)Math.ceil(Math.max(0.0, this.gen.nextNormalizedDouble() * 32.0 + 32.0))));
                }
                return files;
            }

            @Override
            public void remove() {
            }
        };
    }
}

