/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.io.IOException;
import org.apache.iotdb.rpc.AutoScalingBufferReadTransport;
import org.apache.iotdb.rpc.AutoScalingBufferWriteTransport;
import org.apache.iotdb.rpc.RpcStat;
import org.apache.iotdb.rpc.TElasticFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;

public abstract class TCompressedElasticFramedTransport
extends TElasticFramedTransport {
    private AutoScalingBufferWriteTransport writeCompressBuffer;
    private AutoScalingBufferReadTransport readCompressBuffer;

    protected TCompressedElasticFramedTransport(TTransport underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize) {
        super(underlying, thriftDefaultBufferSize, thriftMaxFrameSize);
        this.writeCompressBuffer = new AutoScalingBufferWriteTransport(thriftDefaultBufferSize);
        this.readCompressBuffer = new AutoScalingBufferReadTransport(thriftDefaultBufferSize);
    }

    @Override
    protected void readFrame() throws TTransportException {
        this.underlying.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize((byte[])this.i32buf);
        if (size < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size + ")!");
        }
        this.readBuffer.fill(this.underlying, size);
        RpcStat.readCompressedBytes.addAndGet(size);
        try {
            int uncompressedLength = this.uncompressedLength(this.readBuffer.getBuffer(), 0, size);
            RpcStat.readBytes.addAndGet(uncompressedLength);
            this.readCompressBuffer.resizeIfNecessary(uncompressedLength);
            this.uncompress(this.readBuffer.getBuffer(), 0, size, this.readCompressBuffer.getBuffer(), 0);
            this.readCompressBuffer.limit(uncompressedLength);
            this.readCompressBuffer.position(0);
            this.readBuffer.fill(this.readCompressBuffer, uncompressedLength);
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    @Override
    public void flush() throws TTransportException {
        int length = this.writeBuffer.getPos();
        RpcStat.writeBytes.addAndGet(length);
        try {
            int maxCompressedLength = this.maxCompressedLength(length);
            this.writeCompressBuffer.resizeIfNecessary(maxCompressedLength);
            int compressedLength = this.compress(this.writeBuffer.getBuffer(), 0, length, this.writeCompressBuffer.getBuffer(), 0);
            RpcStat.writeCompressedBytes.addAndGet(compressedLength);
            TFramedTransport.encodeFrameSize((int)compressedLength, (byte[])this.i32buf);
            this.underlying.write(this.i32buf, 0, 4);
            this.underlying.write(this.writeCompressBuffer.getBuffer(), 0, compressedLength);
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
        this.writeBuffer.reset();
        if (this.thriftDefaultBufferSize < length) {
            this.writeBuffer.resizeIfNecessary(this.thriftDefaultBufferSize);
        }
        this.underlying.flush();
    }

    protected abstract int uncompressedLength(byte[] var1, int var2, int var3) throws IOException;

    protected abstract int maxCompressedLength(int var1);

    protected abstract int compress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

    protected abstract void uncompress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;
}

