/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiAuthenticationCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiConfidentialityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiIntegrityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.IpmiAuthenticationAlgorithmWrapper;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.IpmiConfidentialityAlgorithmWrapper;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.IpmiIntegrityAlgorithmWrapper;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class RmcpPlusOpenSessionRequest
extends AbstractSessionIpmiPayload {
    public AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel = AbstractSessionIpmiPayload.MaximumPrivilegeLevel.UNSPECIFIED;
    public int consoleSessionId;
    public IpmiAuthenticationCode authenticationCode;
    public IpmiIntegrityCode integrityCode;
    public IpmiConfidentialityCode confidentialityCode;

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 32;
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        buffer.put(this.messageTag);
        buffer.put(this.maximumPrivilegeLevel.getCode());
        RmcpPlusOpenSessionRequest.reservedBytes(buffer, 2);
        IpmiSession ipmiSession = context.getIpmiSession();
        this.consoleSessionId = ipmiSession.getConsoleSessionId();
        this.authenticationCode = ipmiSession.getAuthenticationAlgorithm();
        this.integrityCode = ipmiSession.getIntegrityAlgorithm();
        this.confidentialityCode = ipmiSession.getConfidentialityAlgorithm();
        ByteOrderUtils.writeLeInt(buffer, this.consoleSessionId);
        IpmiAuthenticationAlgorithmWrapper authenticationAlgorithmWrapper = new IpmiAuthenticationAlgorithmWrapper(this.authenticationCode);
        authenticationAlgorithmWrapper.toWire(context, buffer);
        IpmiIntegrityAlgorithmWrapper integrityAlgorithmWrapper = new IpmiIntegrityAlgorithmWrapper(this.integrityCode);
        integrityAlgorithmWrapper.toWire(context, buffer);
        IpmiConfidentialityAlgorithmWrapper confidentialityAlgorithmWrapper = new IpmiConfidentialityAlgorithmWrapper(this.confidentialityCode);
        confidentialityAlgorithmWrapper.toWire(context, buffer);
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.RMCPOpenSessionRequest;
    }
}

