/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteCteException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAugmentMaterializationRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAugmentSnapshotMaterializationRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.DruidSqlOperatorConverter;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QueryTables;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.TxnIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMaterializedViewUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewUtils.class);

    private HiveMaterializedViewUtils() {
    }

    public static Table extractTable(RelOptMaterialization materialization) {
        RelOptHiveTable cachedMaterializedViewTable = materialization.tableRel instanceof Project ? (RelOptHiveTable)materialization.tableRel.getInput(0).getTable() : (RelOptHiveTable)materialization.tableRel.getTable();
        return cachedMaterializedViewTable.getHiveTableMD();
    }

    public static Boolean isOutdatedMaterializedView(Supplier<String> validTxnsList, HiveTxnManager txnMgr, Hive db, Set<TableName> tablesUsed, Table materializedViewTable) throws HiveException {
        MaterializedViewMetadata mvMetadata = materializedViewTable.getMVMetadata();
        MaterializationSnapshot snapshot = mvMetadata.getSnapshot();
        if (snapshot != null && snapshot.getTableSnapshots() != null && !snapshot.getTableSnapshots().isEmpty()) {
            return HiveMaterializedViewUtils.isOutdatedMaterializedView(snapshot, db, tablesUsed, materializedViewTable);
        }
        String txnString = validTxnsList.get();
        if (txnString == null) {
            return null;
        }
        String materializationTxnList = snapshot != null ? snapshot.getValidTxnList() : null;
        return HiveMaterializedViewUtils.isOutdatedMaterializedView(materializationTxnList, txnString, txnMgr, tablesUsed, materializedViewTable);
    }

    private static Boolean isOutdatedMaterializedView(String materializationTxnList, String validTxnsList, HiveTxnManager txnMgr, Set<TableName> tablesUsed, Table materializedViewTable) throws LockException {
        List<String> tablesUsedNames = tablesUsed.stream().map(tableName -> TableName.getDbTable((String)tableName.getDb(), (String)tableName.getTable())).collect(Collectors.toList());
        ValidTxnWriteIdList currentTxnWriteIds = txnMgr.getValidWriteIds(tablesUsedNames, validTxnsList);
        if (currentTxnWriteIds == null) {
            LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as we could not obtain current txn ids");
            return null;
        }
        Set<String> storedTablesUsed = materializedViewTable.getMVMetadata().getSourceTableFullNames();
        if (materializationTxnList == null || materializationTxnList.isEmpty()) {
            LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as we could not obtain materialization txn ids");
            return null;
        }
        ValidTxnWriteIdList materializationTxnWriteIds = ValidTxnWriteIdList.fromValue((String)materializationTxnList);
        boolean ignore = false;
        for (String fullyQualifiedTableName : tablesUsedNames) {
            if (!storedTablesUsed.contains(fullyQualifiedTableName)) continue;
            ValidWriteIdList tableCurrentWriteIds = currentTxnWriteIds.getTableValidWriteIdList(fullyQualifiedTableName);
            if (tableCurrentWriteIds == null) {
                LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as it is outdated and cannot be considered for  rewriting because it uses non-transactional table " + fullyQualifiedTableName);
                ignore = true;
                break;
            }
            ValidWriteIdList tableWriteIds = materializationTxnWriteIds.getTableValidWriteIdList(fullyQualifiedTableName);
            if (tableWriteIds == null) {
                LOG.warn("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as details about txn ids for table " + fullyQualifiedTableName + " could not be found in " + String.valueOf(materializationTxnWriteIds));
                ignore = true;
                break;
            }
            if (TxnIdUtils.checkEquivalentWriteIds((ValidWriteIdList)tableCurrentWriteIds, (ValidWriteIdList)tableWriteIds)) continue;
            LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " contents are outdated");
            return true;
        }
        if (ignore) {
            return null;
        }
        return false;
    }

    private static Boolean isOutdatedMaterializedView(MaterializationSnapshot snapshot, Hive db, Set<TableName> tablesUsed, Table materializedViewTable) throws HiveException {
        List tablesUsedNames = tablesUsed.stream().map(tableName -> TableName.getDbTable((String)tableName.getDb(), (String)tableName.getTable())).collect(Collectors.toList());
        Map snapshotMap = snapshot.getTableSnapshots();
        if (snapshotMap == null || snapshotMap.isEmpty()) {
            LOG.debug("Materialized view {} ignored for rewriting as we could not obtain current snapshot ids", (Object)materializedViewTable.getFullyQualifiedName());
            return null;
        }
        Set<String> storedTablesUsed = materializedViewTable.getMVMetadata().getSourceTableFullNames();
        for (String fullyQualifiedTableName : tablesUsedNames) {
            SnapshotContext storedTableSnapshot;
            if (!storedTablesUsed.contains(fullyQualifiedTableName)) continue;
            Table table = db.getTable(fullyQualifiedTableName);
            if (table.getStorageHandler() == null) {
                LOG.debug("Materialized view {} ignored for rewriting as we could not get storage handler of table {}", (Object)materializedViewTable.getFullyQualifiedName(), (Object)fullyQualifiedTableName);
                return null;
            }
            if (!table.getStorageHandler().areSnapshotsSupported()) {
                LOG.debug("Materialized view {} ignored for rewriting as storage handler of table {} does not support snapshots.", (Object)materializedViewTable.getFullyQualifiedName(), (Object)fullyQualifiedTableName);
                return null;
            }
            SnapshotContext currentTableSnapshot = table.getStorageHandler().getCurrentSnapshotContext(table);
            if (Objects.equals(currentTableSnapshot, storedTableSnapshot = (SnapshotContext)snapshotMap.get(fullyQualifiedTableName))) continue;
            LOG.debug("Materialized view {} contents are outdated", (Object)materializedViewTable.getFullyQualifiedName());
            return true;
        }
        return false;
    }

    public static HiveRelOptMaterialization augmentMaterializationWithTimeInformation(HiveRelOptMaterialization materialization, Supplier<String> validTxnsList, MaterializationSnapshot snapshot) throws LockException {
        RelNode modifiedQueryRel;
        if (snapshot != null && snapshot.getTableSnapshots() != null && !snapshot.getTableSnapshots().isEmpty()) {
            modifiedQueryRel = HiveMaterializedViewUtils.applyRule(materialization.queryRel, HiveAugmentSnapshotMaterializationRule.with(snapshot.getTableSnapshots()));
        } else {
            String materializationTxnList = snapshot != null ? snapshot.getValidTxnList() : null;
            modifiedQueryRel = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation(materialization, validTxnsList, ValidTxnWriteIdList.fromValue((String)materializationTxnList));
        }
        return new HiveRelOptMaterialization(materialization.tableRel, modifiedQueryRel, null, materialization.qualifiedTableName, materialization.getScope(), materialization.getRebuildMode(), materialization.getAst());
    }

    private static RelNode augmentMaterializationWithTimeInformation(HiveRelOptMaterialization materialization, Supplier<String> validTxnsList, ValidTxnWriteIdList materializationTxnList) throws LockException {
        final ArrayList<String> tablesUsed = new ArrayList<String>();
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    TableScan ts = (TableScan)node;
                    tablesUsed.add(((RelOptHiveTable)ts.getTable()).getHiveTableMD().getFullyQualifiedName());
                }
                super.visit(node, ordinal, parent);
            }
        }.go(materialization.queryRel);
        ValidTxnWriteIdList currentTxnList = SessionState.get().getTxnMgr().getValidWriteIds(tablesUsed, validTxnsList.get());
        RexBuilder rexBuilder = materialization.queryRel.getCluster().getRexBuilder();
        return HiveMaterializedViewUtils.applyRule(materialization.queryRel, new HiveAugmentMaterializationRule(rexBuilder, currentTxnList, materializationTxnList));
    }

    @VisibleForTesting
    static RelNode applyRule(RelNode basePlan, RelOptRule relOptRule) {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        programBuilder.addRuleInstance(relOptRule);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.setRoot(basePlan);
        return planner.findBestExp();
    }

    public static List<HiveRelOptMaterialization> deriveGroupingSetsMaterializedViews(HiveRelOptMaterialization materialization) {
        Aggregate aggregate;
        Project project;
        RelNode query = materialization.queryRel;
        if (query instanceof Aggregate) {
            project = null;
            aggregate = (Aggregate)query;
        } else if (query instanceof Project && query.getInput(0) instanceof Aggregate) {
            project = (Project)query;
            aggregate = (Aggregate)query.getInput(0);
        } else {
            project = null;
            aggregate = null;
        }
        if (aggregate == null) {
            return Collections.singletonList(materialization);
        }
        if (aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            return Collections.singletonList(materialization);
        }
        int aggregateGroupingIdIndex = -1;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (((AggregateCall)aggregate.getAggCallList().get(i)).getAggregation() != HiveGroupingID.INSTANCE) continue;
            aggregateGroupingIdIndex = aggregate.getGroupCount() + i;
            break;
        }
        Preconditions.checkState((aggregateGroupingIdIndex != -1 ? 1 : 0) != 0);
        int projectGroupingIdIndex = -1;
        if (project != null) {
            for (int i = 0; i < project.getProjects().size(); ++i) {
                RexInputRef ref;
                RexNode expr = (RexNode)project.getProjects().get(i);
                if (!(expr instanceof RexInputRef) || (ref = (RexInputRef)expr).getIndex() != aggregateGroupingIdIndex) continue;
                projectGroupingIdIndex = i;
                break;
            }
            if (projectGroupingIdIndex == -1) {
                return Collections.singletonList(materialization);
            }
        }
        ArrayList<HiveRelOptMaterialization> materializationList = new ArrayList<HiveRelOptMaterialization>();
        RelBuilder builder = HiveRelFactories.HIVE_BUILDER.create(aggregate.getCluster(), null);
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        ArrayList aggregateCalls = new ArrayList(aggregate.getAggCallList());
        aggregateCalls.remove(aggregateGroupingIdIndex - aggregate.getGroupCount());
        for (ImmutableBitSet targetGroupSet : aggregate.getGroupSets()) {
            int pos;
            long groupingIdValue = HiveMaterializedViewUtils.convert(targetGroupSet, aggregate.getGroupSet());
            Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), aggregate.getInput(), targetGroupSet, null, aggregateCalls);
            builder.push((RelNode)newAggregate);
            ArrayList<Object> exprs = new ArrayList<Object>();
            for (pos = 0; pos < aggregate.getGroupCount(); ++pos) {
                int ref = aggregate.getGroupSet().nth(pos);
                if (targetGroupSet.get(ref)) {
                    exprs.add(rexBuilder.makeInputRef((RelNode)newAggregate, targetGroupSet.indexOf(ref)));
                    continue;
                }
                exprs.add(rexBuilder.makeNullLiteral(((RelDataTypeField)aggregate.getRowType().getFieldList().get(pos)).getType()));
            }
            pos = targetGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                if (aggregateCall.getAggregation() == HiveGroupingID.INSTANCE) {
                    exprs.add(rexBuilder.makeBigintLiteral(new BigDecimal(groupingIdValue)));
                    continue;
                }
                exprs.add(rexBuilder.makeInputRef((RelNode)newAggregate, pos++));
            }
            if (project != null) {
                Project bottomProject = (Project)builder.project(exprs, (Iterable)ImmutableList.of(), true).build();
                List newNodes = RelOptUtil.pushPastProject((List)project.getProjects(), (Project)bottomProject);
                builder.push(bottomProject.getInput()).project((Iterable)newNodes);
            } else {
                builder.project(exprs);
            }
            RelNode newQueryRel = builder.build();
            builder.push(materialization.tableRel);
            RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(materialization.tableRel, project != null ? projectGroupingIdIndex : aggregateGroupingIdIndex), rexBuilder.makeBigintLiteral(new BigDecimal(groupingIdValue))});
            builder.filter(new RexNode[]{condition});
            RelNode newTableRel = builder.build();
            Table scanTable = HiveMaterializedViewUtils.extractTable(materialization);
            materializationList.add(new HiveRelOptMaterialization(newTableRel, newQueryRel, null, (List<String>)ImmutableList.of((Object)scanTable.getDbName(), (Object)scanTable.getTableName(), (Object)("#" + materializationList.size())), materialization.getScope(), materialization.getRebuildMode(), materialization.getAst()));
        }
        return materializationList;
    }

    private static long convert(ImmutableBitSet targetGroupSet, ImmutableBitSet groupSet) {
        long value = 0L;
        for (int i = 0; i < groupSet.length(); ++i) {
            int bit = groupSet.nth(i);
            value += targetGroupSet.get(bit) ? 0L : 1L << groupSet.length() - i - 1;
        }
        return value;
    }

    public static RelNode copyNodeNewCluster(RelOptCluster optCluster, RelNode node) {
        if (node instanceof Filter) {
            Filter f = (Filter)node;
            return new HiveFilter(optCluster, f.getTraitSet(), HiveMaterializedViewUtils.copyNodeNewCluster(optCluster, f.getInput()), f.getCondition());
        }
        if (node instanceof Project) {
            Project p = (Project)node;
            return HiveProject.create(optCluster, HiveMaterializedViewUtils.copyNodeNewCluster(optCluster, p.getInput()), p.getProjects(), p.getRowType(), Collections.emptyList());
        }
        return HiveMaterializedViewUtils.copyNodeScanNewCluster(optCluster, node);
    }

    public static boolean checkPrivilegeForMaterializedViews(List<Table> cachedMVTableList) throws HiveException {
        ArrayList<HivePrivilegeObject> privObjects = new ArrayList<HivePrivilegeObject>();
        for (Table cachedMVTable : cachedMVTableList) {
            List<String> colNames = cachedMVTable.getAllCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
            HivePrivilegeObject privObject = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, cachedMVTable.getCatalogName(), cachedMVTable.getDbName(), cachedMVTable.getTableName(), null, colNames);
            privObjects.add(privObject);
        }
        try {
            SessionState.get().getAuthorizerV2().checkPrivileges(HiveOperationType.QUERY, privObjects, privObjects, new HiveAuthzContext.Builder().build());
        }
        catch (HiveException e) {
            if (e instanceof HiveAccessControlException) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private static RelNode copyNodeScanNewCluster(RelOptCluster optCluster, RelNode scan) {
        Object newScan;
        if (scan instanceof DruidQuery) {
            DruidQuery dq = (DruidQuery)scan;
            newScan = DruidQuery.create((RelOptCluster)optCluster, (RelTraitSet)optCluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)scan.getTable(), (DruidTable)dq.getDruidTable(), (List)ImmutableList.of((Object)dq.getTableScan()), DruidSqlOperatorConverter.getDefaultMap());
        } else {
            newScan = new HiveTableScan(optCluster, optCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), (RelOptHiveTable)scan.getTable(), ((RelOptHiveTable)scan.getTable()).getName(), null, false, false);
        }
        return newScan;
    }

    public static MaterializationSnapshot getSnapshotOf(DDLOperationContext context, Set<TableName> tables) throws HiveException {
        Map<String, SnapshotContext> snapshot = HiveMaterializedViewUtils.getSnapshotOf(context.getDb(), tables);
        if (snapshot.isEmpty()) {
            return new MaterializationSnapshot(context.getConf().get("hive.txn.tables.valid.writeids"));
        }
        return new MaterializationSnapshot(snapshot);
    }

    private static Map<String, SnapshotContext> getSnapshotOf(Hive db, Set<TableName> tables) throws HiveException {
        HashMap<String, SnapshotContext> snapshot = new HashMap<String, SnapshotContext>(tables.size());
        for (TableName tableName : tables) {
            Table table = db.getTable(tableName);
            if (table.getStorageHandler() != null) {
                HiveStorageHandler storageHandler = table.getStorageHandler();
                if (!storageHandler.areSnapshotsSupported()) {
                    return Collections.emptyMap();
                }
                snapshot.put(table.getFullyQualifiedName(), storageHandler.getCurrentSnapshotContext(table));
                continue;
            }
            return Collections.emptyMap();
        }
        return snapshot;
    }

    public static RelOptMaterialization createCTEMaterialization(String viewName, RelNode body, HiveConf conf) {
        RelOptCluster cluster = body.getCluster();
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        for (RelDataTypeField f : body.getRowType().getFieldList()) {
            TypeInfo info = TypeConverter.convert(f.getType());
            columns.add(new ColumnInfo(f.getName(), info, f.getType().isNullable(), viewName, false, false));
        }
        List<String> fullName = Arrays.asList("cte", viewName);
        org.apache.hadoop.hive.metastore.api.Table metaTable = Table.getEmptyTable("cte", viewName);
        metaTable.setTemporary(true);
        try {
            metaTable.getSd().setLocation(SessionState.generateTempTableLocation((Configuration)conf));
        }
        catch (MetaException e) {
            throw new CalciteCteException("Failed to create temporary location", e);
        }
        Table hiveTable = new Table(metaTable);
        hiveTable.setMaterializedTable(true);
        RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullName, body.getRowType(), hiveTable, columns, Collections.emptyList(), Collections.emptyList(), new HiveConf(), new QueryTables(true), new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
        optTable.setRowCount(cluster.getMetadataQuery().getRowCount(body));
        HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewName, null, false, false);
        return new RelOptMaterialization((RelNode)scan, body, null, fullName);
    }
}

