/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubqueryRuntimeException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteViewSemanticException;

public enum CBOFallbackStrategy {
    NEVER{

        @Override
        boolean isFatal(Exception e) {
            return true;
        }

        @Override
        public boolean allowsRetry() {
            return false;
        }
    }
    ,
    CONSERVATIVE{

        @Override
        boolean isFatal(Exception e) {
            return e instanceof CalciteSubquerySemanticException || e instanceof CalciteViewSemanticException || e instanceof CalciteSubqueryRuntimeException;
        }

        @Override
        public boolean allowsRetry() {
            return true;
        }
    }
    ,
    ALWAYS{

        @Override
        boolean isFatal(Exception e) {
            return false;
        }

        @Override
        public boolean allowsRetry() {
            return true;
        }
    };


    abstract boolean isFatal(Exception var1);

    public abstract boolean allowsRetry();
}

