/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SinglePrimitiveValueBoundaryScanner;

class TimestampPrimitiveValueBoundaryScanner
extends SinglePrimitiveValueBoundaryScanner<Double> {
    public TimestampPrimitiveValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreaterPrimitive(Double l1Seconds, Double l2Seconds, int amt) {
        if (l1Seconds != null && l2Seconds != null) {
            return (l1Seconds - l2Seconds) / 1000.0 > (double)amt;
        }
        return l1Seconds != null || l2Seconds != null;
    }

    @Override
    public boolean isEqualPrimitive(Double l1Seconds, Double l2Seconds) {
        if (l1Seconds != null && l2Seconds != null) {
            return l1Seconds.equals(l2Seconds);
        }
        return l1Seconds == null && l2Seconds == null;
    }
}

