/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.hop.pipeline.transforms.repeatfields;

import lombok.Getter;
import lombok.Setter;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFieldsMeta.RepeatType;

@Getter
@Setter
public class Repeat {
  @HopMetadataProperty(storeWithCode = true)
  private RepeatType type;

  @HopMetadataProperty(key = "source_field")
  private String sourceField;

  @HopMetadataProperty(key = "target_field")
  private String targetField;

  @HopMetadataProperty(key = "indicator_field_name")
  private String indicatorFieldName;

  @HopMetadataProperty(key = "indicator_value")
  private String indicatorValue;

  public Repeat() {}

  public Repeat(Repeat r) {
    this.type = r.type;
    this.sourceField = r.sourceField;
    this.targetField = r.targetField;
    this.indicatorFieldName = r.indicatorFieldName;
    this.indicatorValue = r.indicatorValue;
  }
}
