/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

public class MinMaxAvgDouble {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double total = 0.0;

    public void add(double value) {
        this.total += value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void add(MinMaxAvgDouble other) {
        this.total += other.total;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    public void diff(double start, double end) {
        this.add(end - start);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getTotal() {
        return this.total;
    }

    public double getAvg(double count) {
        return count == 0.0 ? 0.0 : this.total / count;
    }
}

