/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import java.net.SocketAddress;
import java.util.BitSet;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.client.proto.ProtocolVersion;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.apache.ignite3.internal.tostring.S;

public class ClientContext {
    private final ProtocolVersion version;
    private final int clientCode;
    private final BitSet features;
    private final UserDetails userDetails;
    private final SocketAddress remoteAddress;

    ClientContext(ProtocolVersion version, int clientCode, BitSet features, UserDetails userDetails, SocketAddress remoteAddress) {
        this.version = version;
        this.clientCode = clientCode;
        this.features = features;
        this.userDetails = userDetails;
        this.remoteAddress = remoteAddress;
    }

    public ProtocolVersion version() {
        return this.version;
    }

    public int clientCode() {
        return this.clientCode;
    }

    public boolean hasFeature(ProtocolBitmaskFeature feature) {
        return this.features.get(feature.featureId());
    }

    public boolean hasAllFeatures(ProtocolBitmaskFeature ... features) {
        for (ProtocolBitmaskFeature feature : features) {
            if (this.features.get(feature.featureId())) continue;
            return false;
        }
        return true;
    }

    public UserDetails userDetails() {
        return this.userDetails;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        return S.toString(ClientContext.class, this);
    }
}

