/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.transport;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.apache.bifromq.basecluster.transport.AbstractTransport;
import org.apache.bifromq.basecluster.transport.ProbeHandler;
import org.apache.bifromq.basecluster.transport.proto.Packet;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.basehlc.HLC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TCPTransport
extends AbstractTransport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TCPTransport.class);
    private final Counter sendBytes;
    private final Counter recvBytes;
    private final DistributionSummary transportLatency;
    private final ClientBridger clientBridger = new ClientBridger();
    private final ServerBridger serverBridger = new ServerBridger();
    private final ConcurrentMap<InetSocketAddress, LoadingCache<Integer, ChannelFuture>> channelMaps = new ConcurrentHashMap<InetSocketAddress, LoadingCache<Integer, ChannelFuture>>();
    private final ThreadLocal<Integer> threadChannelKey = new ThreadLocal();
    private final EventLoopGroup elg;
    private final TCPTransportOptions opts;
    private final AtomicInteger nextChannelKey = new AtomicInteger(0);
    private final Bootstrap clientBootstrap;
    private final ChannelFuture tcpListeningChannel;

    TCPTransport(@NonNull String env, InetSocketAddress bindAddr, SslContext serverSslContext, SslContext clientSslContext, TCPTransportOptions opts) {
        super(env);
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        try {
            Preconditions.checkArgument((opts.connTimeoutInMS > 0 ? 1 : 0) != 0, (Object)"connTimeoutInMS must be a positive number");
            Preconditions.checkArgument((opts.maxBufferSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxBufferSizeInBytes must be a positive number");
            Preconditions.checkArgument((opts.maxChannelsPerHost > 0 ? 1 : 0) != 0, (Object)"maxChannelsPerHost must be a positive number");
            this.opts = opts.toBuilder().build();
            this.elg = NettyEnv.createEventLoopGroup((int)4, (String)"cluster-tcp-transport");
            this.clientBootstrap = this.setupTcpClient(clientSslContext);
            this.tcpListeningChannel = this.setupTcpServer(bindAddr, serverSslContext);
            InetSocketAddress localAddress = (InetSocketAddress)this.tcpListeningChannel.channel().localAddress();
            Tags tags = Tags.of((String)"proto", (String)"tcp").and("local", localAddress.getAddress().getHostAddress() + ":" + localAddress.getPort());
            this.sendBytes = Counter.builder((String)"basecluster.send.bytes").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.recvBytes = Counter.builder((String)"basecluster.recv.bytes").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.transportLatency = DistributionSummary.builder((String)"basecluster.transport.latency").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            log.debug("Creating tcp transport: bindAddr={}", (Object)localAddress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize tcp transport", e);
        }
    }

    private static void trace(String format, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace(format, args);
        }
    }

    private Bootstrap setupTcpClient(final SslContext sslContext) {
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)clientBootstrap.group(this.elg)).channel(NettyEnv.getSocketChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.opts.maxBufferSizeInBytes / 2, this.opts.maxBufferSizeInBytes))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.opts.connTimeoutInMS);
        clientBootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                if (sslContext != null) {
                    channel.pipeline().addLast("ssl", (ChannelHandler)sslContext.newHandler(channel.alloc()));
                }
                channel.pipeline().addLast("probe", (ChannelHandler)new ProbeHandler()).addLast("frameDecoder", (ChannelHandler)new ProtobufVarint32FrameDecoder()).addLast("protoBufDecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)Packet.getDefaultInstance())).addLast("frameEncoder", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender()).addLast("protoBufEncoder", (ChannelHandler)new ProtobufEncoder()).addLast("bridger", (ChannelHandler)TCPTransport.this.clientBridger);
            }
        });
        return clientBootstrap;
    }

    private ChannelFuture setupTcpServer(InetSocketAddress serverAddr, final SslContext sslContext) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        return ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.elg).channel(NettyEnv.getServerSocketChannelClass())).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).localAddress((SocketAddress)serverAddr)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                if (sslContext != null) {
                    channel.pipeline().addLast("ssl", (ChannelHandler)sslContext.newHandler(channel.alloc()));
                }
                channel.pipeline().addLast("probe", (ChannelHandler)new ProbeHandler()).addLast("frameDecoder", (ChannelHandler)new ProtobufVarint32FrameDecoder()).addLast("protoBufDecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)Packet.getDefaultInstance())).addLast("frameEncoder", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender()).addLast("protoBufEncoder", (ChannelHandler)new ProtobufEncoder()).addLast("Bridger", (ChannelHandler)TCPTransport.this.serverBridger);
            }
        }).bind().sync();
    }

    @Override
    public InetSocketAddress bindAddress() {
        return (InetSocketAddress)this.tcpListeningChannel.channel().localAddress();
    }

    @Override
    protected CompletableFuture<Void> doSend(Packet packet, InetSocketAddress recipient) {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        this.getChannel(recipient).whenComplete((ch, e) -> {
            if (e != null) {
                log.debug("Failed to connect to address: {}, cause={}", (Object)recipient, (Object)e.getMessage());
                onDone.completeExceptionally((Throwable)e);
            } else if (ch.isWritable()) {
                long packetLength = packet.getSerializedSize();
                this.sendBytes.increment((double)packetLength);
                ch.writeAndFlush((Object)packet);
                onDone.complete(null);
            } else {
                onDone.completeExceptionally(new RuntimeException("Channel is not writable"));
            }
        });
        return onDone;
    }

    @Override
    protected Completable doShutdown() {
        log.debug("Closing tcp transport");
        return Completable.concatArrayDelayError((CompletableSource[])new CompletableSource[]{Completable.fromRunnable(() -> this.channelMaps.forEach((r, cm) -> cm.invalidateAll())), Completable.fromFuture((Future)this.tcpListeningChannel.channel().close()), Completable.fromFuture((Future)this.elg.shutdownGracefully(0L, 5L, TimeUnit.SECONDS)), Completable.fromRunnable(() -> {
            Metrics.globalRegistry.remove((Meter)this.sendBytes);
            Metrics.globalRegistry.remove((Meter)this.recvBytes);
            Metrics.globalRegistry.remove((Meter)this.transportLatency);
        })}).onErrorComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    CompletableFuture<Channel> getChannel(InetSocketAddress recipient) {
        if (this.threadChannelKey.get() == null) {
            this.threadChannelKey.set(this.nextChannelKey.getAndUpdate(k -> (k + 1) % this.opts.maxChannelsPerHost));
        }
        Integer channelKey = this.threadChannelKey.get();
        ChannelFuture cf = (ChannelFuture)this.channelMaps.compute(recipient, (r, cm) -> {
            if (cm == null) {
                cm = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(Duration.ofSeconds(this.opts.idleTimeoutInSec)).removalListener((k, v, cause) -> {
                    if (v != null && v.isDone() && v.channel().isActive()) {
                        TCPTransport.trace("Closing #{} channel: remote={}, cause={}", k, v.channel().remoteAddress(), cause);
                        v.channel().close();
                    }
                }).build(k -> {
                    TCPTransport.trace("Setup #{} channel: remote={}", k, recipient);
                    return this.clientBootstrap.connect((SocketAddress)recipient);
                });
            }
            return cm;
        }).get((Object)channelKey);
        if (cf.isDone()) {
            if (cf.channel().isActive()) {
                return CompletableFuture.completedFuture(cf.channel());
            }
            ChannelFuture channelFuture = cf;
            synchronized (channelFuture) {
                if (cf == ((LoadingCache)this.channelMaps.get(recipient)).get((Object)channelKey)) {
                    log.debug("Rebuild #{} channel: remote={}", (Object)channelKey, (Object)recipient);
                    ((LoadingCache)this.channelMaps.get(recipient)).invalidate((Object)channelKey);
                }
            }
            return this.getChannel(recipient);
        }
        CompletableFuture<Channel> f = new CompletableFuture<Channel>();
        cf.addListener(future -> {
            if (future.isSuccess() && future.channel().isActive()) {
                f.complete(future.channel());
            } else {
                try {
                    future.get();
                }
                catch (Exception e) {
                    f.completeExceptionally(e);
                }
            }
        });
        return f;
    }

    @Generated
    public static TCPTransportBuilder builder() {
        return new TCPTransportBuilder();
    }

    @ChannelHandler.Sharable
    private static class ClientBridger
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) {
            TCPTransport.trace("Outbound channel active: remote={}", ctx.channel().remoteAddress());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            TCPTransport.trace("Outbound channel inactive: remote={}", ctx.channel().remoteAddress());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.warn("Outbound channel failure: remote={}, cause={}", (Object)ctx.channel().remoteAddress(), (Object)cause.getMessage());
            ctx.close();
        }
    }

    @ChannelHandler.Sharable
    private class ServerBridger
    extends SimpleChannelInboundHandler<Packet> {
        protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
            TCPTransport.trace("Received message: remote={}", ctx.channel().remoteAddress());
            TCPTransport.this.recvBytes.increment((double)packet.getSerializedSize());
            TCPTransport.this.transportLatency.record((double)HLC.INST.getPhysical(packet.getHlc() - HLC.INST.get()));
            TCPTransport.this.doReceive(packet, (InetSocketAddress)ctx.channel().remoteAddress(), (InetSocketAddress)ctx.channel().localAddress());
        }

        public void channelActive(ChannelHandlerContext ctx) {
            TCPTransport.trace("Inbound channel active: remote={}", ctx.channel().remoteAddress());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            TCPTransport.trace("Inbound channel inactive: remote={}", ctx.channel().remoteAddress());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.warn("Inbound channel failure: remote={}, cause={}", (Object)ctx.channel().remoteAddress(), (Object)cause.getMessage());
            ctx.close();
        }
    }

    public static class TCPTransportOptions {
        private int connTimeoutInMS;
        private int idleTimeoutInSec;
        private int maxChannelsPerHost;
        private int maxBufferSizeInBytes;

        @Generated
        private static int $default$connTimeoutInMS() {
            return 5000;
        }

        @Generated
        private static int $default$idleTimeoutInSec() {
            return 5;
        }

        @Generated
        private static int $default$maxChannelsPerHost() {
            return 5;
        }

        @Generated
        private static int $default$maxBufferSizeInBytes() {
            return WriteBufferWaterMark.DEFAULT.high();
        }

        @Generated
        public static TCPTransportOptionsBuilder builder() {
            return new TCPTransportOptionsBuilder();
        }

        @Generated
        public TCPTransportOptionsBuilder toBuilder() {
            return new TCPTransportOptionsBuilder().connTimeoutInMS(this.connTimeoutInMS).idleTimeoutInSec(this.idleTimeoutInSec).maxChannelsPerHost(this.maxChannelsPerHost).maxBufferSizeInBytes(this.maxBufferSizeInBytes);
        }

        @Generated
        public int connTimeoutInMS() {
            return this.connTimeoutInMS;
        }

        @Generated
        public int idleTimeoutInSec() {
            return this.idleTimeoutInSec;
        }

        @Generated
        public int maxChannelsPerHost() {
            return this.maxChannelsPerHost;
        }

        @Generated
        public int maxBufferSizeInBytes() {
            return this.maxBufferSizeInBytes;
        }

        @Generated
        public TCPTransportOptions connTimeoutInMS(int connTimeoutInMS) {
            this.connTimeoutInMS = connTimeoutInMS;
            return this;
        }

        @Generated
        public TCPTransportOptions idleTimeoutInSec(int idleTimeoutInSec) {
            this.idleTimeoutInSec = idleTimeoutInSec;
            return this;
        }

        @Generated
        public TCPTransportOptions maxChannelsPerHost(int maxChannelsPerHost) {
            this.maxChannelsPerHost = maxChannelsPerHost;
            return this;
        }

        @Generated
        public TCPTransportOptions maxBufferSizeInBytes(int maxBufferSizeInBytes) {
            this.maxBufferSizeInBytes = maxBufferSizeInBytes;
            return this;
        }

        @Generated
        public TCPTransportOptions() {
            this.connTimeoutInMS = TCPTransportOptions.$default$connTimeoutInMS();
            this.idleTimeoutInSec = TCPTransportOptions.$default$idleTimeoutInSec();
            this.maxChannelsPerHost = TCPTransportOptions.$default$maxChannelsPerHost();
            this.maxBufferSizeInBytes = TCPTransportOptions.$default$maxBufferSizeInBytes();
        }

        @Generated
        private TCPTransportOptions(int connTimeoutInMS, int idleTimeoutInSec, int maxChannelsPerHost, int maxBufferSizeInBytes) {
            this.connTimeoutInMS = connTimeoutInMS;
            this.idleTimeoutInSec = idleTimeoutInSec;
            this.maxChannelsPerHost = maxChannelsPerHost;
            this.maxBufferSizeInBytes = maxBufferSizeInBytes;
        }

        @Generated
        public static class TCPTransportOptionsBuilder {
            @Generated
            private boolean connTimeoutInMS$set;
            @Generated
            private int connTimeoutInMS$value;
            @Generated
            private boolean idleTimeoutInSec$set;
            @Generated
            private int idleTimeoutInSec$value;
            @Generated
            private boolean maxChannelsPerHost$set;
            @Generated
            private int maxChannelsPerHost$value;
            @Generated
            private boolean maxBufferSizeInBytes$set;
            @Generated
            private int maxBufferSizeInBytes$value;

            @Generated
            TCPTransportOptionsBuilder() {
            }

            @Generated
            public TCPTransportOptionsBuilder connTimeoutInMS(int connTimeoutInMS) {
                this.connTimeoutInMS$value = connTimeoutInMS;
                this.connTimeoutInMS$set = true;
                return this;
            }

            @Generated
            public TCPTransportOptionsBuilder idleTimeoutInSec(int idleTimeoutInSec) {
                this.idleTimeoutInSec$value = idleTimeoutInSec;
                this.idleTimeoutInSec$set = true;
                return this;
            }

            @Generated
            public TCPTransportOptionsBuilder maxChannelsPerHost(int maxChannelsPerHost) {
                this.maxChannelsPerHost$value = maxChannelsPerHost;
                this.maxChannelsPerHost$set = true;
                return this;
            }

            @Generated
            public TCPTransportOptionsBuilder maxBufferSizeInBytes(int maxBufferSizeInBytes) {
                this.maxBufferSizeInBytes$value = maxBufferSizeInBytes;
                this.maxBufferSizeInBytes$set = true;
                return this;
            }

            @Generated
            public TCPTransportOptions build() {
                int connTimeoutInMS$value = this.connTimeoutInMS$value;
                if (!this.connTimeoutInMS$set) {
                    connTimeoutInMS$value = TCPTransportOptions.$default$connTimeoutInMS();
                }
                int idleTimeoutInSec$value = this.idleTimeoutInSec$value;
                if (!this.idleTimeoutInSec$set) {
                    idleTimeoutInSec$value = TCPTransportOptions.$default$idleTimeoutInSec();
                }
                int maxChannelsPerHost$value = this.maxChannelsPerHost$value;
                if (!this.maxChannelsPerHost$set) {
                    maxChannelsPerHost$value = TCPTransportOptions.$default$maxChannelsPerHost();
                }
                int maxBufferSizeInBytes$value = this.maxBufferSizeInBytes$value;
                if (!this.maxBufferSizeInBytes$set) {
                    maxBufferSizeInBytes$value = TCPTransportOptions.$default$maxBufferSizeInBytes();
                }
                return new TCPTransportOptions(connTimeoutInMS$value, idleTimeoutInSec$value, maxChannelsPerHost$value, maxBufferSizeInBytes$value);
            }

            @Generated
            public String toString() {
                return "TCPTransport.TCPTransportOptions.TCPTransportOptionsBuilder(connTimeoutInMS$value=" + this.connTimeoutInMS$value + ", idleTimeoutInSec$value=" + this.idleTimeoutInSec$value + ", maxChannelsPerHost$value=" + this.maxChannelsPerHost$value + ", maxBufferSizeInBytes$value=" + this.maxBufferSizeInBytes$value + ")";
            }
        }
    }

    @Generated
    public static class TCPTransportBuilder {
        @Generated
        private String env;
        @Generated
        private InetSocketAddress bindAddr;
        @Generated
        private SslContext serverSslContext;
        @Generated
        private SslContext clientSslContext;
        @Generated
        private TCPTransportOptions opts;

        @Generated
        TCPTransportBuilder() {
        }

        @Generated
        public TCPTransportBuilder env(@NonNull String env) {
            if (env == null) {
                throw new NullPointerException("env is marked non-null but is null");
            }
            this.env = env;
            return this;
        }

        @Generated
        public TCPTransportBuilder bindAddr(InetSocketAddress bindAddr) {
            this.bindAddr = bindAddr;
            return this;
        }

        @Generated
        public TCPTransportBuilder serverSslContext(SslContext serverSslContext) {
            this.serverSslContext = serverSslContext;
            return this;
        }

        @Generated
        public TCPTransportBuilder clientSslContext(SslContext clientSslContext) {
            this.clientSslContext = clientSslContext;
            return this;
        }

        @Generated
        public TCPTransportBuilder opts(TCPTransportOptions opts) {
            this.opts = opts;
            return this;
        }

        @Generated
        public TCPTransport build() {
            return new TCPTransport(this.env, this.bindAddr, this.serverSslContext, this.clientSslContext, this.opts);
        }

        @Generated
        public String toString() {
            return "TCPTransport.TCPTransportBuilder(env=" + this.env + ", bindAddr=" + String.valueOf(this.bindAddr) + ", serverSslContext=" + String.valueOf(this.serverSslContext) + ", clientSslContext=" + String.valueOf(this.clientSslContext) + ", opts=" + String.valueOf(this.opts) + ")";
        }
    }
}

