<!--
     Licensed to the Apache Software Foundation (ASF) under one
     or more contributor license agreements.  See the NOTICE file
     distributed with this work for additional information
     regarding copyright ownership.  The ASF licenses this file
     to you under the Apache License, Version 2.0 (the
     "License"); you may not use this file except in compliance
     with the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

     Unless required by applicable law or agreed to in writing,
     software distributed under the License is distributed on an
     "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
     KIND, either express or implied.  See the License for the
     specific language governing permissions and limitations
     under the License.
-->

# Agent patterns

We have the bones of a few applications that can be used to create agents. These are not fully fleshed out, but they
can be used as a starting point for creating your own agents.

We have the following templates:

## Multimodal agent

[Code template](https://github.com/apache/burr/tree/main/examples/templates/multi_modal_agent.py)

![](./_agent_patterns/multi_modal_agent.png)

## Multi-agent collaboration

[Code template](https://github.com/apache/burr/tree/main/examples/templates/multi_agent_collaboration.py)

![](./_agent_patterns/multi_agent_collaboration.png)

## Supervisor agent

[Code template](https://github.com/apache/burr/tree/main/examples/templates/agent_supervisor.py)

![](./_agent_patterns/agent_supervisor.png)


## Hierarchical teams

[Code template](https://github.com/apache/burr/tree/main/examples/templates/hierarchical_agent_teams.py)

![](./_agent_patterns/hierarchical_agent_teams.png)
