---
id: 'code-review-guide'
title: 'Code Review 指南'
---

本指南适用于所有希望协助代码贡献评审的提交者和贡献者。感谢您的付出，优质的评审是开源项目中最重要且关键的环节之一。本指南旨在帮助社区实现以下评审目标：

- 让贡献者获得良好的贡献体验。
- 确保代码审查结构化，全面覆盖贡献的核心要点。
- 保障项目维持高代码质量标准。
- 避免出现贡献者与审阅者耗费大量时间打磨贡献，最终仍遭拒绝的情况。

## Code Review 指南

- 始终保持一个较高的标准来进行审核，这样才能更好地保证整个产品的质量。
- 对于接口类的、整体架构方面的修改，需要在社区进行充分地讨论，可以在邮件组发起，也可以在 Issue 上发起。
- 测试覆盖。新增的逻辑需要有对应的测试来覆盖。对于已有老代码，不好增加的可以酌情考虑。
- 文档。新增加的功能必须要有文档来说明，否则这样的代码不允许合并。必须要有英文文档，最好有中文文档。
- 代码的可读性。如果 Reviewer 对于代码逻辑不是很清晰，那么可以要求 Contributor 去解释这段逻辑，并且需要在代码里写充分的注释来解释逻辑。
- 尽量在评论的结尾给出明确的结论。是同意，还是要 change request。如果是小问题，可以只留评论。
- 如果已经看过了代码，觉得没有问题，但是觉得还需要其他 Reviewer 来确认下，可以留下 +1 Comment。
- 互相尊重，互相学习。在评论的时候保持礼貌的口吻，提建议尽量给出建议的理由。

## PR Review 指南

- 检查贡献内容是否描述充分，足以支持高质量的评审。
- Reviewer 需进行代码层级的评审。
- Reviewer 对 PR 发表评论后，需持续跟进该 PR 后续的修改。
- 每个 PR 至少要获得一个 **非作者外的 Committer +1** 才能允许进行被合并。
- PR 获得第一个 +1 后，建议等待 **一个工作日** 后才进行合并。主要目的是等待社区其他 Reviewer 来进行审核。
- 对于接口类、整体架构方面等被认为是重大变更，则至少要获得 **3 个 +1** 才能进行合并。
- 合并前需确保回归测试与持续集成测试全部通过。
- 合并时请选择“squash and merge”操作。
- 不同的 Reviewer 对 PR 有争议时，可以尝试讨论解决。如果讨论无法解决，可通过`dev@fesod.apache.org`发起邮件投票解决，采取少数服从多数的原则。
