/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Collection;
import org.apache.fluss.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.fluss.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ECBlockGroupStats {
    private final long lowRedundancyBlockGroups;
    private final long corruptBlockGroups;
    private final long missingBlockGroups;
    private final long bytesInFutureBlockGroups;
    private final long pendingDeletionBlocks;
    private final Long highestPriorityLowRedundancyBlocks;

    public ECBlockGroupStats(long lowRedundancyBlockGroups, long corruptBlockGroups, long missingBlockGroups, long bytesInFutureBlockGroups, long pendingDeletionBlocks) {
        this(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks, null);
    }

    public ECBlockGroupStats(long lowRedundancyBlockGroups, long corruptBlockGroups, long missingBlockGroups, long bytesInFutureBlockGroups, long pendingDeletionBlocks, Long highestPriorityLowRedundancyBlocks) {
        this.lowRedundancyBlockGroups = lowRedundancyBlockGroups;
        this.corruptBlockGroups = corruptBlockGroups;
        this.missingBlockGroups = missingBlockGroups;
        this.bytesInFutureBlockGroups = bytesInFutureBlockGroups;
        this.pendingDeletionBlocks = pendingDeletionBlocks;
        this.highestPriorityLowRedundancyBlocks = highestPriorityLowRedundancyBlocks;
    }

    public long getBytesInFutureBlockGroups() {
        return this.bytesInFutureBlockGroups;
    }

    public long getCorruptBlockGroups() {
        return this.corruptBlockGroups;
    }

    public long getLowRedundancyBlockGroups() {
        return this.lowRedundancyBlockGroups;
    }

    public long getMissingBlockGroups() {
        return this.missingBlockGroups;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocks;
    }

    public boolean hasHighestPriorityLowRedundancyBlocks() {
        return this.getHighestPriorityLowRedundancyBlocks() != null;
    }

    public Long getHighestPriorityLowRedundancyBlocks() {
        return this.highestPriorityLowRedundancyBlocks;
    }

    public String toString() {
        StringBuilder statsBuilder = new StringBuilder();
        statsBuilder.append("ECBlockGroupStats=[").append("LowRedundancyBlockGroups=").append(this.getLowRedundancyBlockGroups()).append(", CorruptBlockGroups=").append(this.getCorruptBlockGroups()).append(", MissingBlockGroups=").append(this.getMissingBlockGroups()).append(", BytesInFutureBlockGroups=").append(this.getBytesInFutureBlockGroups()).append(", PendingDeletionBlocks=").append(this.getPendingDeletionBlocks());
        if (this.hasHighestPriorityLowRedundancyBlocks()) {
            statsBuilder.append(", HighestPriorityLowRedundancyBlocks=").append(this.getHighestPriorityLowRedundancyBlocks());
        }
        statsBuilder.append("]");
        return statsBuilder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.lowRedundancyBlockGroups).append(this.corruptBlockGroups).append(this.missingBlockGroups).append(this.bytesInFutureBlockGroups).append(this.pendingDeletionBlocks).append(this.highestPriorityLowRedundancyBlocks).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECBlockGroupStats other = (ECBlockGroupStats)o;
        return new EqualsBuilder().append(this.lowRedundancyBlockGroups, other.lowRedundancyBlockGroups).append(this.corruptBlockGroups, other.corruptBlockGroups).append(this.missingBlockGroups, other.missingBlockGroups).append(this.bytesInFutureBlockGroups, other.bytesInFutureBlockGroups).append(this.pendingDeletionBlocks, other.pendingDeletionBlocks).append(this.highestPriorityLowRedundancyBlocks, other.highestPriorityLowRedundancyBlocks).isEquals();
    }

    public static ECBlockGroupStats merge(Collection<ECBlockGroupStats> stats) {
        long lowRedundancyBlockGroups = 0L;
        long corruptBlockGroups = 0L;
        long missingBlockGroups = 0L;
        long bytesInFutureBlockGroups = 0L;
        long pendingDeletionBlocks = 0L;
        long highestPriorityLowRedundancyBlocks = 0L;
        boolean hasHighestPriorityLowRedundancyBlocks = false;
        for (ECBlockGroupStats stat : stats) {
            lowRedundancyBlockGroups += stat.getLowRedundancyBlockGroups();
            corruptBlockGroups += stat.getCorruptBlockGroups();
            missingBlockGroups += stat.getMissingBlockGroups();
            bytesInFutureBlockGroups += stat.getBytesInFutureBlockGroups();
            pendingDeletionBlocks += stat.getPendingDeletionBlocks();
            if (!stat.hasHighestPriorityLowRedundancyBlocks()) continue;
            hasHighestPriorityLowRedundancyBlocks = true;
            highestPriorityLowRedundancyBlocks += stat.getHighestPriorityLowRedundancyBlocks().longValue();
        }
        if (hasHighestPriorityLowRedundancyBlocks) {
            return new ECBlockGroupStats(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks, highestPriorityLowRedundancyBlocks);
        }
        return new ECBlockGroupStats(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks);
    }
}

