/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.lake.paimon.source.PaimonRecordReader;
import org.apache.fluss.lake.paimon.source.PaimonSortedRecordReader;
import org.apache.fluss.lake.paimon.source.PaimonSplit;
import org.apache.fluss.lake.paimon.source.PaimonSplitPlanner;
import org.apache.fluss.lake.paimon.source.PaimonSplitSerializer;
import org.apache.fluss.lake.paimon.utils.FlussToPaimonPredicateConverter;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.lake.serializer.SimpleVersionedSerializer;
import org.apache.fluss.lake.source.LakeSource;
import org.apache.fluss.lake.source.Planner;
import org.apache.fluss.lake.source.RecordReader;
import org.apache.fluss.metadata.TablePath;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;

public class PaimonLakeSource
implements LakeSource<PaimonSplit> {
    private static final long serialVersionUID = 1L;
    private final Configuration paimonConfig;
    private final TablePath tablePath;
    @Nullable
    private int[][] project;
    @Nullable
    private Predicate predicate;

    public PaimonLakeSource(Configuration paimonConfig, TablePath tablePath) {
        this.paimonConfig = paimonConfig;
        this.tablePath = tablePath;
    }

    public void withProject(int[][] project) {
        this.project = project;
    }

    public void withLimit(int limit) {
        throw new UnsupportedOperationException("Not impl.");
    }

    public LakeSource.FilterPushDownResult withFilters(List<org.apache.fluss.predicate.Predicate> predicates) {
        ArrayList<org.apache.fluss.predicate.Predicate> unConsumedPredicates = new ArrayList<org.apache.fluss.predicate.Predicate>();
        ArrayList<org.apache.fluss.predicate.Predicate> consumedPredicates = new ArrayList<org.apache.fluss.predicate.Predicate>();
        ArrayList<Predicate> converted = new ArrayList<Predicate>();
        RowType rowType = this.getRowType(this.tablePath);
        for (org.apache.fluss.predicate.Predicate predicate : predicates) {
            Optional<Predicate> optPredicate = FlussToPaimonPredicateConverter.convert(rowType, predicate);
            if (optPredicate.isPresent()) {
                consumedPredicates.add(predicate);
                converted.add(optPredicate.get());
                continue;
            }
            unConsumedPredicates.add(predicate);
        }
        if (!converted.isEmpty()) {
            this.predicate = PredicateBuilder.and(converted);
        }
        return LakeSource.FilterPushDownResult.of(consumedPredicates, unConsumedPredicates);
    }

    public Planner<PaimonSplit> createPlanner(LakeSource.PlannerContext plannerContext) {
        return new PaimonSplitPlanner(this.paimonConfig, this.tablePath, this.predicate, plannerContext.snapshotId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordReader createRecordReader(LakeSource.ReaderContext<PaimonSplit> context) throws IOException {
        try (Catalog catalog = this.getCatalog();){
            FileStoreTable fileStoreTable = this.getTable(catalog, this.tablePath);
            if (fileStoreTable.primaryKeys().isEmpty()) {
                PaimonRecordReader paimonRecordReader = new PaimonRecordReader(fileStoreTable, (PaimonSplit)context.lakeSplit(), this.project, this.predicate);
                return paimonRecordReader;
            }
            PaimonSortedRecordReader paimonSortedRecordReader = new PaimonSortedRecordReader(fileStoreTable, (PaimonSplit)context.lakeSplit(), this.project, this.predicate);
            return paimonSortedRecordReader;
        }
        catch (Exception e) {
            throw new IOException("Fail to create record reader.", e);
        }
    }

    public SimpleVersionedSerializer<PaimonSplit> getSplitSerializer() {
        return new PaimonSplitSerializer();
    }

    private Catalog getCatalog() {
        return CatalogFactory.createCatalog(CatalogContext.create(Options.fromMap(this.paimonConfig.toMap())));
    }

    private FileStoreTable getTable(Catalog catalog, TablePath tablePath) throws Exception {
        return (FileStoreTable)catalog.getTable(PaimonConversions.toPaimon(tablePath));
    }

    private RowType getRowType(TablePath tablePath) {
        RowType rowType;
        block8: {
            Catalog catalog = this.getCatalog();
            try {
                FileStoreTable fileStoreTable = this.getTable(catalog, tablePath);
                rowType = fileStoreTable.rowType();
                if (catalog == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (catalog != null) {
                        try {
                            catalog.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Fail to get row type of " + String.valueOf(tablePath), e);
                }
            }
            catalog.close();
        }
        return rowType;
    }
}

