/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.paimon.disk.BufferFileReader;
import org.apache.paimon.disk.BufferFileReaderImpl;
import org.apache.paimon.disk.BufferFileWriter;
import org.apache.paimon.disk.BufferFileWriterImpl;
import org.apache.paimon.disk.FileChannelManager;
import org.apache.paimon.disk.FileChannelManagerImpl;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOManagerImpl
implements IOManager {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManagerImpl.class);
    private static final String DIR_NAME_PREFIX = "io";
    private final String[] tempDirs;
    private volatile FileChannelManager lazyChannelManager;

    public IOManagerImpl(String ... tempDirs) {
        Preconditions.checkNotNull(tempDirs);
        this.tempDirs = tempDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileChannelManager fileChannelManager() {
        if (this.lazyChannelManager == null) {
            IOManagerImpl iOManagerImpl = this;
            synchronized (iOManagerImpl) {
                if (this.lazyChannelManager == null) {
                    this.lazyChannelManager = new FileChannelManagerImpl(this.tempDirs, DIR_NAME_PREFIX);
                }
            }
        }
        return this.lazyChannelManager;
    }

    @Override
    public void close() throws Exception {
        if (this.lazyChannelManager != null) {
            this.lazyChannelManager.close();
        }
    }

    @Override
    public FileIOChannel.ID createChannel() {
        return this.fileChannelManager().createChannel();
    }

    @Override
    public FileIOChannel.ID createChannel(String prefix) {
        return this.fileChannelManager().createChannel(prefix);
    }

    @Override
    public String[] tempDirs() {
        return this.tempDirs;
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        return this.fileChannelManager().createChannelEnumerator();
    }

    public static void deleteChannel(FileIOChannel.ID channel) {
        if (channel != null && channel.getPathFile().exists() && !channel.getPathFile().delete()) {
            LOG.warn("IOManager failed to delete temporary file {}", (Object)channel.getPath());
        }
    }

    public File[] getSpillingDirectories() {
        return this.fileChannelManager().getPaths();
    }

    public String[] getSpillingDirectoriesPaths() {
        File[] paths = this.fileChannelManager().getPaths();
        String[] strings = new String[paths.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = paths[i].getAbsolutePath();
        }
        return strings;
    }

    private String getSpillingDirectoriesPathsString() {
        return Arrays.stream(this.fileChannelManager().getPaths()).map(File::getAbsolutePath).collect(Collectors.joining("\n\t"));
    }

    @Override
    public BufferFileWriter createBufferFileWriter(FileIOChannel.ID channelID) throws IOException {
        return new BufferFileWriterImpl(channelID);
    }

    @Override
    public BufferFileReader createBufferFileReader(FileIOChannel.ID channelID) throws IOException {
        return new BufferFileReaderImpl(channelID);
    }

    public static String[] splitPaths(@Nonnull String separatedPaths) {
        return separatedPaths.length() > 0 ? separatedPaths.split(",|" + File.pathSeparator) : new String[]{};
    }
}

