/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import org.apache.paimon.jdbc.JdbcDistributedLockDialect;
import org.apache.paimon.jdbc.MysqlDistributedLockDialect;
import org.apache.paimon.jdbc.PostgresqlDistributedLockDialect;
import org.apache.paimon.jdbc.SqlLiteDistributedLockDialect;

class DistributedLockDialectFactory {
    DistributedLockDialectFactory() {
    }

    static JdbcDistributedLockDialect create(String protocol) {
        JdbcProtocol type = JdbcProtocol.valueOf(protocol.toUpperCase());
        switch (type) {
            case SQLITE: {
                return new SqlLiteDistributedLockDialect();
            }
            case MYSQL: {
                return new MysqlDistributedLockDialect();
            }
            case POSTGRESQL: {
                return new PostgresqlDistributedLockDialect();
            }
        }
        throw new UnsupportedOperationException(String.format("Distributed locks based on %s are not supported", protocol));
    }

    static enum JdbcProtocol {
        SQLITE,
        MARIADB,
        MYSQL,
        POSTGRESQL;

    }
}

