/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.append.MultiTableAppendCompactTask;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.IdentifierSerializer;
import org.apache.paimon.utils.SerializationUtils;

public class MultiTableCompactionTaskSerializer
implements VersionedSerializer<MultiTableAppendCompactTask> {
    private static final int CURRENT_VERSION = 1;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();
    private final IdentifierSerializer identifierSerializer = new IdentifierSerializer();

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public byte[] serialize(MultiTableAppendCompactTask task) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(task, view);
        return out.toByteArray();
    }

    private void serialize(MultiTableAppendCompactTask task, DataOutputView view) throws IOException {
        SerializationUtils.serializeBinaryRow(task.partition(), view);
        this.dataFileSerializer.serializeList(task.compactBefore(), view);
        this.identifierSerializer.serialize(task.tableIdentifier(), view);
    }

    @Override
    public MultiTableAppendCompactTask deserialize(int version, byte[] serialized) throws IOException {
        this.checkVersion(version);
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(view);
    }

    private MultiTableAppendCompactTask deserialize(DataInputView view) throws IOException {
        return new MultiTableAppendCompactTask(SerializationUtils.deserializeBinaryRow(view), this.dataFileSerializer.deserializeList(view), (Identifier)this.identifierSerializer.deserialize(view));
    }

    public List<MultiTableAppendCompactTask> deserializeList(int version, DataInputView view) throws IOException {
        this.checkVersion(version);
        int length = view.readInt();
        ArrayList<MultiTableAppendCompactTask> list = new ArrayList<MultiTableAppendCompactTask>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(view));
        }
        return list;
    }

    public void serializeList(List<MultiTableAppendCompactTask> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (MultiTableAppendCompactTask commitMessage : list) {
            this.serialize(commitMessage, view);
        }
    }

    private void checkVersion(int version) {
        if (version != 1) {
            throw new UnsupportedOperationException("Expecting MultiTableCompactionTaskSerializer version to be 1, but found " + version + ".\nCompactionTask is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
    }
}

