/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import com.alibaba.nacos.common.utils.ResourceUtils;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSettingPropertySource
extends AbstractPropertySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSettingPropertySource.class);
    private static final String DEFAULT_SETTING_PATH = "classpath:nacos_default_setting.properties";
    private final Properties defaultSetting = new Properties();

    DefaultSettingPropertySource() {
        try (InputStream inputStream = ResourceUtils.getResourceUrl(DEFAULT_SETTING_PATH).openStream();){
            this.defaultSetting.load(inputStream);
        }
        catch (Exception e) {
            LOGGER.error("load default setting failed", (Throwable)e);
        }
    }

    @Override
    SourceType getType() {
        return SourceType.DEFAULT_SETTING;
    }

    @Override
    String getProperty(String key) {
        return this.defaultSetting.getProperty(key);
    }

    @Override
    boolean containsKey(String key) {
        return this.defaultSetting.containsKey(key);
    }

    @Override
    Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultSetting);
        return properties;
    }
}

