/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataDbAntennaSignal
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 6965646323859387882L;
    private static final int LENGTH = 1;
    private final byte antennaSignal;

    public static RadiotapDataDbAntennaSignal newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataDbAntennaSignal(rawData, offset, length);
    }

    private RadiotapDataDbAntennaSignal(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapDbAntennaSignal (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.antennaSignal = ByteArrays.getByte(rawData, offset);
    }

    private RadiotapDataDbAntennaSignal(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is null.");
        }
        this.antennaSignal = builder.antennaSignal;
    }

    public byte getAntennaSignal() {
        return this.antennaSignal;
    }

    public int getAntennaSignalAsInt() {
        return this.antennaSignal & 0xFF;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.antennaSignal);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("dB antenna signal: ").append(ls).append(indent).append("  Antenna signal: ").append(this.getAntennaSignalAsInt()).append(" dB").append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.antennaSignal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataDbAntennaSignal other = (RadiotapDataDbAntennaSignal)obj;
        return this.antennaSignal == other.antennaSignal;
    }

    public static final class Builder {
        private byte antennaSignal;

        public Builder() {
        }

        private Builder(RadiotapDataDbAntennaSignal obj) {
            this.antennaSignal = obj.antennaSignal;
        }

        public Builder antennaSignal(byte antennaSignal) {
            this.antennaSignal = antennaSignal;
            return this;
        }

        public RadiotapDataDbAntennaSignal build() {
            return new RadiotapDataDbAntennaSignal(this);
        }
    }
}

