/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.compress;

import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.WrappedInputStream;
import com.clickhouse.data.stream.WrappedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public final class GzipSupport {
    private static int normalize(int level) {
        return level < -1 || level > 9 ? -1 : level;
    }

    public static ClickHouseCompressionAlgorithm getInstance() {
        return Factory.instance;
    }

    private GzipSupport() {
    }

    static final class Factory {
        private static final ClickHouseCompressionAlgorithm instance = ClickHouseCompressionAlgorithm.createInstance("gzip_lib_detection", PreferredImpl.class, DefaultImpl.class);

        private Factory() {
        }
    }

    public static class PreferredImpl
    implements ClickHouseCompressionAlgorithm {
        public PreferredImpl() {
            new GzipParameters();
        }

        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            GzipParameters params = new GzipParameters();
            params.setBufferSize(bufferSize);
            params.setCompressionLevel(GzipSupport.normalize(level));
            return new WrappedOutputStream(stream, (OutputStream)new GzipCompressorOutputStream(output, params), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedInputStream(stream, (InputStream)new GzipCompressorInputStream(input, true), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.GZIP;
        }
    }

    public static class DefaultImpl
    implements ClickHouseCompressionAlgorithm {
        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedOutputStream(stream, new GZIPOutputStream(output), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedInputStream(stream, new GZIPInputStream(input), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.GZIP;
        }
    }
}

