/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client.handler;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.client.UdpConnection;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.IpmiHandler;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSdrRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSdrResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSensorReadingRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSensorReadingResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.ReserveSdrRepositoryRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.ReserveSdrRepositoryResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code.IpmiReadingTypeCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorHandler
implements IpmiHandler {
    private static final Logger log = LoggerFactory.getLogger(SensorHandler.class);

    @Override
    public void handler(IpmiSession session, UdpConnection connection, CollectRep.MetricsData.Builder builder, Metrics metrics) throws IOException {
        ReserveSdrRepositoryResponse response = connection.get(session, new ReserveSdrRepositoryRequest(), ReserveSdrRepositoryResponse.class);
        int reserveId = response.reserveId;
        int recordId = GetSdrRequest.RECORD_ID_START;
        while (recordId != 65535) {
            GetSdrRequest headRequest = new GetSdrRequest(reserveId, recordId, 0, GetSdrRequest.HEADER_LENGTH);
            GetSdrResponse getSdrHeadResponse = connection.get(session, headRequest, GetSdrResponse.class);
            if (getSdrHeadResponse.recordType != 1) {
                recordId = getSdrHeadResponse.nextRecordId;
                continue;
            }
            HashMap<String, Object> parseValue = new HashMap<String, Object>();
            GetSdrRequest request = new GetSdrRequest(reserveId, recordId, 0, (byte)(getSdrHeadResponse.recordLength + 5));
            recordId = getSdrHeadResponse.nextRecordId;
            GetSdrResponse getSdrBodyResponse = connection.get(session, request, GetSdrResponse.class);
            if (this.isReadable(getSdrBodyResponse)) {
                byte sensorNum = getSdrBodyResponse.sensorNumber;
                GetSensorReadingRequest readingRequest = new GetSensorReadingRequest(sensorNum);
                readingRequest.setRqLun(getSdrBodyResponse.sensorOwnerLun);
                try {
                    GetSensorReadingResponse getSensorReadingResponse = connection.get(session, readingRequest, GetSensorReadingResponse.class);
                    double sensorReading = this.calcSensorValue(getSdrBodyResponse, getSensorReadingResponse.sensorReading);
                    parseValue.put("sensor_reading", String.format("%.3f", sensorReading) + " " + getSdrBodyResponse.unitTypeCode.getDescription());
                }
                catch (Exception e) {
                    log.error("get sensor reading error", (Throwable)e);
                }
            }
            parseValue.put("sensor_id", getSdrBodyResponse.sensorIdString);
            parseValue.put("entity_id", getSdrBodyResponse.entityIdCode.getDescription());
            parseValue.put("sensor_type", getSdrBodyResponse.sensorTypeCode.getDescription());
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (Metrics.Field field : metrics.getFields()) {
                if (!parseValue.containsKey(field.getField())) {
                    valueRowBuilder.addColumn("&nbsp;");
                    continue;
                }
                valueRowBuilder.addColumn((String)parseValue.get(field.getField()));
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    public boolean isReadable(GetSdrResponse response) {
        if (response.recordType != 1) {
            return false;
        }
        if (response.readingTypeCode != IpmiReadingTypeCode.Threshold) {
            return false;
        }
        return response.analogDataFormat != 3;
    }

    public double calcSensorValue(GetSdrResponse response, int raw) {
        switch (response.analogDataFormat) {
            case 0: {
                raw &= 0xFF;
                break;
            }
            case 1: {
                int signbit = raw & 0x80;
                if (signbit == 0) break;
                raw = ~raw & 0x7F;
                raw = -raw;
                break;
            }
            case 2: {
                raw = ByteConvertUtils.getBitsAsSigned(raw, 8);
                break;
            }
            default: {
                return 0.0;
            }
        }
        double value = ((double)(response.m * raw) + (double)response.b * Math.pow(10.0, response.k1)) * Math.pow(10.0, response.k2);
        switch (response.linear) {
            case 1: {
                value = Math.log(value);
                break;
            }
            case 2: {
                value = Math.log10(value);
                break;
            }
            case 3: {
                value = Math.log(value) / Math.log(2.0);
                break;
            }
            case 4: {
                value = Math.exp(value);
                break;
            }
            case 5: {
                value = Math.pow(10.0, value);
                break;
            }
            case 6: {
                value = Math.pow(2.0, value);
                break;
            }
            case 7: {
                value = Math.pow(value, -1.0);
                break;
            }
            case 8: {
                value = Math.pow(value, 2.0);
                break;
            }
            case 9: {
                value = Math.pow(value, 3.0);
                break;
            }
            case 10: {
                value = Math.sqrt(value);
                break;
            }
            case 11: {
                value = Math.cbrt(value);
                break;
            }
        }
        return value;
    }
}

