/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;

@InterfaceAudience.Private
public class TraceAdminProtocolTranslatorPB
implements TraceAdminProtocol,
ProtocolTranslator,
Closeable {
    private final TraceAdminProtocolPB rpcProxy;

    public TraceAdminProtocolTranslatorPB(TraceAdminProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        ArrayList<SpanReceiverInfo> infos = new ArrayList<SpanReceiverInfo>(1);
        try {
            TraceAdminPB.ListSpanReceiversRequestProto req = TraceAdminPB.ListSpanReceiversRequestProto.newBuilder().build();
            TraceAdminPB.ListSpanReceiversResponseProto resp = this.rpcProxy.listSpanReceivers(null, req);
            for (TraceAdminPB.SpanReceiverListInfo info : resp.getDescriptionsList()) {
                infos.add(new SpanReceiverInfo(info.getId(), info.getClassName()));
            }
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
        return infos.toArray(new SpanReceiverInfo[infos.size()]);
    }

    @Override
    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        try {
            TraceAdminPB.AddSpanReceiverRequestProto.Builder bld = TraceAdminPB.AddSpanReceiverRequestProto.newBuilder();
            bld.setClassName(info.getClassName());
            for (SpanReceiverInfo.ConfigurationPair configPair : info.configPairs) {
                TraceAdminPB.ConfigPair tuple = TraceAdminPB.ConfigPair.newBuilder().setKey(configPair.getKey()).setValue(configPair.getValue()).build();
                bld.addConfig(tuple);
            }
            TraceAdminPB.AddSpanReceiverResponseProto resp = this.rpcProxy.addSpanReceiver(null, bld.build());
            return resp.getId();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeSpanReceiver(long spanReceiverId) throws IOException {
        try {
            TraceAdminPB.RemoveSpanReceiverRequestProto req = TraceAdminPB.RemoveSpanReceiverRequestProto.newBuilder().setId(spanReceiverId).build();
            this.rpcProxy.removeSpanReceiver(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

