/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.impl.FileRangeImpl;

@InterfaceAudience.Private
public class CombinedFileRange
extends FileRangeImpl {
    private final List<FileRange> underlying = new ArrayList<FileRange>();
    private long dataSize;

    public CombinedFileRange(long offset, long end, FileRange original) {
        super(offset, (int)(end - offset), null);
        this.append(original);
    }

    private void append(FileRange range) {
        this.underlying.add(range);
        this.dataSize += (long)range.getLength();
    }

    public List<FileRange> getUnderlying() {
        return this.underlying;
    }

    public boolean merge(long otherOffset, long otherEnd, FileRange other, int minSeek, int maxSize) {
        long end = this.getOffset() + (long)this.getLength();
        long newEnd = Math.max(end, otherEnd);
        if (otherOffset - end >= (long)minSeek || newEnd - this.getOffset() > (long)maxSize) {
            return false;
        }
        this.setLength((int)(newEnd - this.getOffset()));
        this.append(other);
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("; range count=%d, data size=%,d", this.underlying.size(), this.dataSize);
    }

    public long getDataSize() {
        return this.dataSize;
    }
}

