/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.basicconfig.TimeoutConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class TimeoutConfigImpl
implements TimeoutConfig {
    private final String description;
    private final String configKey;
    private final Timeout instance;
    private Long _value;
    private ChronoUnit _unit;

    private TimeoutConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Timeout.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.timeout;
    }

    private TimeoutConfigImpl(String id, Timeout instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static TimeoutConfigImpl create(FaultToleranceMethod method) {
        if (method.timeout == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("timeout.enabled", "Timeout/enabled", method.method)) {
            return null;
        }
        return new TimeoutConfigImpl(method);
    }

    public static TimeoutConfigImpl create(String id, Supplier<Timeout> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("timeout.enabled", "Timeout/enabled", id)) {
            return null;
        }
        return new TimeoutConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    public long value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".timeout.value";
            Object oldKey = this.configKey + "/Timeout/value";
            this._value = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> TimeoutConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.timeout.value";
                oldKey = "Timeout/value";
                this._value = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> TimeoutConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public ChronoUnit unit() {
        if (this._unit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".timeout.unit";
            Object oldKey = this.configKey + "/Timeout/unit";
            this._unit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> TimeoutConfigImpl.lambda$unit$2(config, (String)oldKey)).orElse(null);
            if (this._unit == null) {
                newKey = "smallrye.faulttolerance.global.timeout.unit";
                oldKey = "Timeout/unit";
                this._unit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> TimeoutConfigImpl.lambda$unit$3(config, (String)oldKey)).orElse(null);
            }
            if (this._unit == null) {
                this._unit = this.instance.unit();
            }
        }
        return this._unit;
    }

    public void materialize() {
        this.value();
        this.unit();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$unit$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$unit$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }
}

