/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.tracing;

import io.smallrye.mutiny.Uni;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.polaris.service.tracing.RequestIdGenerator;

@ApplicationScoped
public class DefaultRequestIdGenerator
implements RequestIdGenerator {
    final AtomicReference<RequestId> state = new AtomicReference<RequestId>(new RequestId());

    @Override
    public Uni<String> generateRequestId(ContainerRequestContext requestContext) {
        return Uni.createFrom().item((Object)this.nextRequestId().toString());
    }

    RequestId nextRequestId() {
        return this.state.getAndUpdate(RequestId::increment);
    }

    record RequestId(UUID uuid, long counter) {
        RequestId() {
            this(UUID.randomUUID(), 1L);
        }

        @Override
        @Nonnull
        public String toString() {
            return String.format("%s_%019d", this.uuid(), this.counter());
        }

        RequestId increment() {
            return this.counter == Long.MAX_VALUE ? new RequestId() : new RequestId(this.uuid, this.counter + 1L);
        }
    }
}

