/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagers {
    private static final LockManager LOCK_MANAGER_DEFAULT = new InMemoryLockManager(Maps.newHashMap());

    private LockManagers() {
    }

    public static LockManager defaultLockManager() {
        return LOCK_MANAGER_DEFAULT;
    }

    public static LockManager from(Map<String, String> properties) {
        if (properties.containsKey("lock-impl")) {
            return LockManagers.loadLockManager(properties.get("lock-impl"), properties);
        }
        return LockManagers.defaultLockManager();
    }

    private static LockManager loadLockManager(String impl, Map<String, String> properties) {
        LockManager lockManager;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(LockManager.class).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize LockManager, missing no-arg constructor: %s", impl), e);
        }
        try {
            lockManager = (LockManager)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize LockManager, %s does not implement LockManager.", impl), e);
        }
        lockManager.initialize(properties);
        return lockManager;
    }

    static class InMemoryLockManager
    extends BaseLockManager {
        private static final Logger LOG = LoggerFactory.getLogger(InMemoryLockManager.class);
        private static final Map<String, InMemoryLockContent> LOCKS = Maps.newConcurrentMap();
        private static final Map<String, ScheduledFuture<?>> HEARTBEATS = Maps.newHashMap();

        InMemoryLockManager(Map<String, String> properties) {
            this.initialize(properties);
        }

        @VisibleForTesting
        void acquireOnce(String entityId, String ownerId) {
            InMemoryLockContent previous;
            InMemoryLockContent content = LOCKS.get(entityId);
            if (content != null && content.expireMs() > System.currentTimeMillis()) {
                throw new IllegalStateException(String.format("Lock for %s currently held by %s, expiration: %s", entityId, content.ownerId(), content.expireMs()));
            }
            long expiration = System.currentTimeMillis() + this.heartbeatTimeoutMs();
            boolean succeed = content == null ? (previous = LOCKS.putIfAbsent(entityId, new InMemoryLockContent(ownerId, expiration))) == null : LOCKS.replace(entityId, content, new InMemoryLockContent(ownerId, expiration));
            if (succeed) {
                if (HEARTBEATS.containsKey(entityId)) {
                    HEARTBEATS.remove(entityId).cancel(false);
                }
            } else {
                throw new IllegalStateException("Unable to acquire lock " + entityId);
            }
            HEARTBEATS.put(entityId, this.scheduler().scheduleAtFixedRate(() -> {
                InMemoryLockContent lastContent = LOCKS.get(entityId);
                try {
                    long newExpiration = System.currentTimeMillis() + this.heartbeatTimeoutMs();
                    LOCKS.replace(entityId, lastContent, new InMemoryLockContent(ownerId, newExpiration));
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("Cannot heartbeat to a deleted lock " + entityId, e);
                }
            }, 0L, this.heartbeatIntervalMs(), TimeUnit.MILLISECONDS));
        }

        public boolean acquire(String entityId, String ownerId) {
            try {
                Tasks.foreach(entityId).retry(0x7FFFFFFE).onlyRetryOn((Class<Exception>)IllegalStateException.class).throwFailureWhenFinished().exponentialBackoff(this.acquireIntervalMs(), this.acquireIntervalMs(), this.acquireTimeoutMs(), 1.0).run(id -> this.acquireOnce((String)id, ownerId));
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }

        public boolean release(String entityId, String ownerId) {
            InMemoryLockContent currentContent = LOCKS.get(entityId);
            if (currentContent == null) {
                LOG.error("Cannot find lock for entity {}", (Object)entityId);
                return false;
            }
            if (!currentContent.ownerId().equals(ownerId)) {
                LOG.error("Cannot unlock {} by {}, current owner: {}", new Object[]{entityId, ownerId, currentContent.ownerId()});
                return false;
            }
            Optional.ofNullable(HEARTBEATS.remove(entityId)).ifPresent(future -> future.cancel(false));
            LOCKS.remove(entityId);
            return true;
        }

        @Override
        public void close() throws Exception {
            HEARTBEATS.values().forEach(future -> future.cancel(false));
            HEARTBEATS.clear();
            LOCKS.clear();
            super.close();
        }
    }

    private static class InMemoryLockContent {
        private final String ownerId;
        private final long expireMs;

        InMemoryLockContent(String ownerId, long expireMs) {
            this.ownerId = ownerId;
            this.expireMs = expireMs;
        }

        public long expireMs() {
            return this.expireMs;
        }

        public String ownerId() {
            return this.ownerId;
        }
    }

    public static abstract class BaseLockManager
    implements LockManager {
        private static volatile ScheduledExecutorService scheduler;
        private long acquireTimeoutMs;
        private long acquireIntervalMs;
        private long heartbeatIntervalMs;
        private long heartbeatTimeoutMs;
        private int heartbeatThreads;

        public long heartbeatTimeoutMs() {
            return this.heartbeatTimeoutMs;
        }

        public long heartbeatIntervalMs() {
            return this.heartbeatIntervalMs;
        }

        public long acquireIntervalMs() {
            return this.acquireIntervalMs;
        }

        public long acquireTimeoutMs() {
            return this.acquireTimeoutMs;
        }

        public int heartbeatThreads() {
            return this.heartbeatThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ScheduledExecutorService scheduler() {
            if (scheduler != null) return scheduler;
            Class<BaseLockManager> clazz = BaseLockManager.class;
            synchronized (BaseLockManager.class) {
                if (scheduler != null) return scheduler;
                scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)((ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(this.heartbeatThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iceberg-lock-manager-%d").build())));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return scheduler;
            }
        }

        public void initialize(Map<String, String> properties) {
            this.acquireTimeoutMs = PropertyUtil.propertyAsLong(properties, "lock.acquire-timeout-ms", CatalogProperties.LOCK_ACQUIRE_TIMEOUT_MS_DEFAULT);
            this.acquireIntervalMs = PropertyUtil.propertyAsLong(properties, "lock.acquire-interval-ms", CatalogProperties.LOCK_ACQUIRE_INTERVAL_MS_DEFAULT);
            this.heartbeatIntervalMs = PropertyUtil.propertyAsLong(properties, "lock.heartbeat-interval-ms", CatalogProperties.LOCK_HEARTBEAT_INTERVAL_MS_DEFAULT);
            this.heartbeatTimeoutMs = PropertyUtil.propertyAsLong(properties, "lock.heartbeat-timeout-ms", CatalogProperties.LOCK_HEARTBEAT_TIMEOUT_MS_DEFAULT);
            this.heartbeatThreads = PropertyUtil.propertyAsInt(properties, "lock.heartbeat-threads", 4);
        }

        public void close() throws Exception {
            if (scheduler != null) {
                List<Runnable> tasks = scheduler.shutdownNow();
                tasks.forEach(task -> {
                    if (task instanceof Future) {
                        ((Future)((Object)task)).cancel(true);
                    }
                });
                scheduler = null;
            }
        }
    }
}

