/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.storage.ImmutableStorageAccessConfig;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.immutables.PolarisImmutable;
import org.immutables.value.Value;

@PolarisImmutable
public interface StorageAccessConfig {
    public Map<String, String> credentials();

    public Map<String, String> extraProperties();

    public Map<String, String> internalProperties();

    public Optional<Instant> expiresAt();

    @Value.Default
    default public boolean supportsCredentialVending() {
        return true;
    }

    default public String get(StorageAccessProperty key) {
        if (key.isCredential()) {
            return this.credentials().get(key.getPropertyName());
        }
        String value = this.internalProperties().get(key.getPropertyName());
        return value != null ? value : this.extraProperties().get(key.getPropertyName());
    }

    public static Builder builder() {
        return ImmutableStorageAccessConfig.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder putCredential(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder putExtraProperty(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder putInternalProperty(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder expiresAt(Instant var1);

        @CanIgnoreReturnValue
        public Builder supportsCredentialVending(boolean var1);

        default public Builder put(StorageAccessProperty key, String value) {
            if (key.isExpirationTimestamp()) {
                this.expiresAt(Instant.ofEpochMilli(Long.parseLong(value)));
            }
            if (key.isCredential()) {
                return this.putCredential(key.getPropertyName(), value);
            }
            return this.putExtraProperty(key.getPropertyName(), value);
        }

        public StorageAccessConfig build();
    }
}

