/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.credentials.connection;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.OAuthClientCredentialsParametersDpo;
import org.apache.polaris.core.credentials.connection.CatalogAccessProperty;
import org.apache.polaris.core.credentials.connection.ConnectionCredentialVendor;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.credentials.connection.AuthType;

@RequestScoped
@AuthType(value=AuthenticationType.OAUTH)
@Priority(value=100)
public class OAuthClientCredentialVendor
implements ConnectionCredentialVendor {
    private static final Joiner COLON_JOINER = Joiner.on((String)":");
    private final UserSecretsManager secretsManager;

    @Inject
    public OAuthClientCredentialVendor(UserSecretsManager secretsManager) {
        this.secretsManager = secretsManager;
    }

    @Nonnull
    public ConnectionCredentials getConnectionCredentials(@Nonnull ConnectionConfigInfoDpo connectionConfig) {
        Preconditions.checkArgument((boolean)(connectionConfig.getAuthenticationParameters() instanceof OAuthClientCredentialsParametersDpo), (String)"Expected OAuthClientCredentialsParametersDpo, got: %s", (Object)connectionConfig.getAuthenticationParameters().getClass().getName());
        OAuthClientCredentialsParametersDpo oauthParams = (OAuthClientCredentialsParametersDpo)connectionConfig.getAuthenticationParameters();
        String clientSecret = this.secretsManager.readSecret(oauthParams.getClientSecretReference());
        String credential = COLON_JOINER.join((Object)oauthParams.getClientId(), (Object)clientSecret, new Object[0]);
        return ConnectionCredentials.builder().put(CatalogAccessProperty.OAUTH2_CREDENTIAL, credential).put(CatalogAccessProperty.EXPIRES_AT_MS, String.valueOf(Long.MAX_VALUE)).build();
    }
}

