/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.identity.provider;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.identity.ServiceIdentityType;
import org.apache.polaris.core.identity.credential.ServiceIdentityCredential;
import org.apache.polaris.core.identity.dpo.AwsIamServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.service.identity.RealmServiceIdentityConfiguration;
import org.apache.polaris.service.identity.ResolvableServiceIdentityConfiguration;
import org.apache.polaris.service.identity.ServiceIdentityConfiguration;

@RequestScoped
public class DefaultServiceIdentityProvider
implements ServiceIdentityProvider {
    public static final String DEFAULT_REALM_KEY = "<default>";
    public static final String DEFAULT_REALM_NSS = "system:default";
    private static final String IDENTITY_INFO_REFERENCE_URN_FORMAT = "urn:polaris-secret:default-identity-provider:%s:%s";
    private final String realm;
    private final RealmServiceIdentityConfiguration config;

    public DefaultServiceIdentityProvider() {
        this.realm = DEFAULT_REALM_KEY;
        this.config = null;
    }

    @Inject
    public DefaultServiceIdentityProvider(RealmContext realmContext, ServiceIdentityConfiguration serviceIdentityConfiguration) {
        ServiceIdentityConfiguration.RealmConfigEntry entry = serviceIdentityConfiguration.forRealm(realmContext);
        this.realm = entry.realm();
        this.config = entry.config();
    }

    public Optional<ServiceIdentityInfoDpo> allocateServiceIdentity(@Nonnull ConnectionConfigInfo connectionConfig) {
        if (this.config == null || connectionConfig.getAuthenticationParameters() == null) {
            return Optional.empty();
        }
        AuthenticationParameters.AuthenticationTypeEnum authType = connectionConfig.getAuthenticationParameters().getAuthenticationType();
        return switch (authType) {
            case AuthenticationParameters.AuthenticationTypeEnum.SIGV4 -> {
                if (this.config.awsIamServiceIdentity().isPresent()) {
                    yield Optional.of(new AwsIamServiceIdentityInfoDpo(DefaultServiceIdentityProvider.buildIdentityInfoReference(this.realm, ServiceIdentityType.AWS_IAM)));
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    public Optional<ServiceIdentityInfo> getServiceIdentityInfo(@Nonnull ServiceIdentityInfoDpo serviceIdentityInfo) {
        if (this.config == null) {
            return Optional.empty();
        }
        SecretReference actualRef = serviceIdentityInfo.getIdentityInfoReference();
        return this.config.serviceIdentityConfigurations().stream().filter(identityConfig -> DefaultServiceIdentityProvider.buildIdentityInfoReference(this.realm, identityConfig.getType()).equals((Object)actualRef)).findFirst().flatMap(ResolvableServiceIdentityConfiguration::asServiceIdentityInfoModel);
    }

    public Optional<ServiceIdentityCredential> getServiceIdentityCredential(@Nonnull ServiceIdentityInfoDpo serviceIdentityInfo) {
        if (this.config == null) {
            return Optional.empty();
        }
        SecretReference ref = serviceIdentityInfo.getIdentityInfoReference();
        return this.config.serviceIdentityConfigurations().stream().filter(identityConfig -> DefaultServiceIdentityProvider.buildIdentityInfoReference(this.realm, identityConfig.getType()).equals((Object)ref)).findFirst().flatMap(identityConfig -> identityConfig.asServiceIdentityCredential(ref));
    }

    @VisibleForTesting
    public RealmServiceIdentityConfiguration getRealmConfig() {
        return this.config;
    }

    public static SecretReference buildIdentityInfoReference(String realm, ServiceIdentityType type) {
        return new SecretReference(IDENTITY_INFO_REFERENCE_URN_FORMAT.formatted(realm.equals(DEFAULT_REALM_KEY) ? DEFAULT_REALM_NSS : realm, type.name()), Map.of());
    }
}

