/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.credentials.connection;

public enum CatalogAccessProperty {
    OAUTH2_CREDENTIAL(String.class, "credential", "the OAuth2 credential", true),
    BEARER_TOKEN(String.class, "token", "the bearer token", true),
    AWS_ACCESS_KEY_ID(String.class, "rest.access-key-id", "the aws access key id", true),
    AWS_SECRET_ACCESS_KEY(String.class, "rest.secret-access-key", "the aws secret access key", true),
    AWS_SESSION_TOKEN(String.class, "rest.session-token", "the aws session token", true),
    AWS_SESSION_TOKEN_EXPIRES_AT_MS(Long.class, "rest.session-token-expires-at-ms", "the time the aws session token expires, in milliseconds", false, true),
    EXPIRES_AT_MS(Long.class, "rest.expires-at-ms", "the expiration time for the access token or the credential, in milliseconds", false, true);

    private final Class valueType;
    private final String propertyName;
    private final String description;
    private final boolean isCredential;
    private final boolean isExpirationTimestamp;

    private CatalogAccessProperty(Class valueType, String propertyName, String description, boolean isCredential) {
        this(valueType, propertyName, description, isCredential, false);
    }

    private CatalogAccessProperty(Class valueType, String propertyName, String description, boolean isCredential, boolean isExpirationTimestamp) {
        this.valueType = valueType;
        this.propertyName = propertyName;
        this.description = description;
        this.isCredential = isCredential;
        this.isExpirationTimestamp = isExpirationTimestamp;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isCredential() {
        return this.isCredential;
    }

    public boolean isExpirationTimestamp() {
        return this.isExpirationTimestamp;
    }
}

