/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Type;

public class ObjectReaderImplJSONP
implements ObjectReader {
    private final Class objectClass;

    public ObjectReaderImplJSONP(Class objectClass) {
        this.objectClass = objectClass;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        JSONPObject jsonp;
        char ch;
        String funcName = jsonReader.readFieldNameUnquote();
        if (jsonReader.nextIfMatch('.')) {
            String name2 = jsonReader.readFieldNameUnquote();
            funcName = funcName + '.' + name2;
        }
        if ((ch = jsonReader.current()) == '/' && jsonReader.nextIfMatchIdent('/', '*', '*', '/')) {
            ch = jsonReader.current();
        }
        if (ch != '(') {
            throw new JSONException(jsonReader.info("illegal jsonp input"));
        }
        jsonReader.next();
        if (this.objectClass == JSONObject.class) {
            jsonp = new JSONPObject(funcName);
        } else {
            try {
                jsonp = (JSONPObject)this.objectClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create jsonp instance error", e);
            }
            jsonp.setFunction(funcName);
        }
        while (true) {
            if (jsonReader.isEnd()) {
                throw new JSONException(jsonReader.info("illegal jsonp input"));
            }
            if (jsonReader.nextIfMatch(')')) break;
            Object param = jsonReader.readAny();
            jsonp.addParameter(param);
        }
        jsonReader.nextIfMatch(';');
        jsonReader.nextIfMatchIdent('/', '*', '*', '/');
        return jsonp;
    }
}

