/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.fory.Fory;
import org.apache.fory.builder.CodecUtils;
import org.apache.fory.builder.Generated;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.collection.ObjectIntMap;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.CodegenSerializer;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.CompatibleSerializerBase;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.util.ExceptionUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.unsafe._JDKAccess;

public class ObjectStreamSerializer
extends AbstractObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStreamSerializer.class);
    private final Constructor constructor;
    private final SlotsInfo[] slotsInfos;
    private static final ClassValue<StreamClassInfo> STREAM_CLASS_INFO_CACHE = new ClassValue<StreamClassInfo>(){

        @Override
        protected StreamClassInfo computeValue(Class<?> type) {
            return new StreamClassInfo(type);
        }
    };

    public ObjectStreamSerializer(Fory fory, Class<?> type) {
        super(fory, type);
        Class<?> end;
        Constructor constructor;
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Class %s should implement %s.", type, Serializable.class));
        }
        LOG.warn("{} customized jdk serialization, which is inefficient. Please replace it with a {} or implements {}", type, Serializer.class.getName(), Externalizable.class.getName());
        fory.getClassResolver().setSerializerIfAbsent(type, this);
        try {
            constructor = type.getConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            constructor = (Constructor)ReflectionUtils.getObjectFieldValue((Object)ObjectStreamClass.lookup(type), "cons");
        }
        this.constructor = constructor;
        ArrayList<SlotsInfo> slotsInfoList = new ArrayList<SlotsInfo>();
        for (end = type; end != null && Serializable.class.isAssignableFrom(end); end = end.getSuperclass()) {
        }
        while (type != end) {
            slotsInfoList.add(new SlotsInfo(fory, type));
            type = type.getSuperclass();
        }
        Collections.reverse(slotsInfoList);
        this.slotsInfos = slotsInfoList.toArray(new SlotsInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MemoryBuffer buffer, Object value) {
        buffer.writeInt16((short)this.slotsInfos.length);
        try {
            for (SlotsInfo slotsInfo : this.slotsInfos) {
                this.classResolver.writeClassInternal(buffer, slotsInfo.classInfo.getCls());
                StreamClassInfo streamClassInfo = slotsInfo.streamClassInfo;
                Method writeObjectMethod = streamClassInfo.writeObjectMethod;
                if (writeObjectMethod == null) {
                    slotsInfo.slotsSerializer.write(buffer, value);
                    continue;
                }
                ForyObjectOutputStream objectOutputStream = slotsInfo.objectOutputStream;
                Object oldObject = objectOutputStream.targetObject;
                MemoryBuffer oldBuffer = objectOutputStream.buffer;
                ForyObjectOutputStream.PutFieldImpl oldPutField = objectOutputStream.curPut;
                boolean fieldsWritten = objectOutputStream.fieldsWritten;
                try {
                    objectOutputStream.targetObject = value;
                    objectOutputStream.buffer = buffer;
                    objectOutputStream.curPut = null;
                    objectOutputStream.fieldsWritten = false;
                    if (streamClassInfo.writeObjectFunc != null) {
                        streamClassInfo.writeObjectFunc.accept(value, objectOutputStream);
                        continue;
                    }
                    writeObjectMethod.invoke(value, objectOutputStream);
                }
                finally {
                    objectOutputStream.targetObject = oldObject;
                    objectOutputStream.buffer = oldBuffer;
                    objectOutputStream.curPut = oldPutField;
                    objectOutputStream.fieldsWritten = fieldsWritten;
                }
            }
        }
        catch (Exception e) {
            ObjectStreamSerializer.throwSerializationException(this.type, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(MemoryBuffer buffer) {
        Object obj = null;
        if (this.constructor != null) {
            try {
                obj = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        } else {
            obj = Platform.newInstance(this.type);
        }
        this.fory.getRefResolver().reference(obj);
        int numClasses = buffer.readInt16();
        int slotIndex = 0;
        try {
            TreeMap callbacks = new TreeMap(Collections.reverseOrder());
            for (int i = 0; i < numClasses; ++i) {
                Class<?> currentClass = this.classResolver.readClassInternal(buffer);
                SlotsInfo slotsInfo = this.slotsInfos[slotIndex++];
                StreamClassInfo streamClassInfo = slotsInfo.streamClassInfo;
                while (currentClass != slotsInfo.cls) {
                    Method readObjectNoData = streamClassInfo.readObjectNoData;
                    if (readObjectNoData != null) {
                        if (streamClassInfo.readObjectNoDataFunc != null) {
                            streamClassInfo.readObjectNoDataFunc.accept(obj);
                        } else {
                            readObjectNoData.invoke(obj, new Object[0]);
                        }
                    }
                    slotsInfo = this.slotsInfos[slotIndex++];
                }
                Method readObjectMethod = streamClassInfo.readObjectMethod;
                if (readObjectMethod == null) {
                    slotsInfo.slotsSerializer.readAndSetFields(buffer, obj);
                    continue;
                }
                ForyObjectInputStream objectInputStream = slotsInfo.objectInputStream;
                MemoryBuffer oldBuffer = objectInputStream.buffer;
                Object oldObject = objectInputStream.targetObject;
                ForyObjectInputStream.GetFieldImpl oldGetField = objectInputStream.getField;
                ForyObjectInputStream.GetFieldImpl getField = (ForyObjectInputStream.GetFieldImpl)slotsInfo.getFieldPool.popOrNull();
                if (getField == null) {
                    getField = new ForyObjectInputStream.GetFieldImpl(slotsInfo);
                }
                boolean fieldsRead = objectInputStream.fieldsRead;
                try {
                    objectInputStream.fieldsRead = false;
                    objectInputStream.buffer = buffer;
                    objectInputStream.targetObject = obj;
                    objectInputStream.getField = getField;
                    objectInputStream.callbacks = callbacks;
                    if (streamClassInfo.readObjectFunc != null) {
                        streamClassInfo.readObjectFunc.accept(obj, objectInputStream);
                        continue;
                    }
                    readObjectMethod.invoke(obj, objectInputStream);
                    continue;
                }
                finally {
                    objectInputStream.fieldsRead = fieldsRead;
                    objectInputStream.buffer = oldBuffer;
                    objectInputStream.targetObject = oldObject;
                    objectInputStream.getField = oldGetField;
                    slotsInfo.getFieldPool.add(getField);
                    objectInputStream.callbacks = null;
                    Arrays.fill(getField.vals, ForyObjectInputStream.NO_VALUE_STUB);
                }
            }
            for (ObjectInputValidation validation : callbacks.values()) {
                validation.validateObject();
            }
        }
        catch (InvalidObjectException | IllegalAccessException | InvocationTargetException e) {
            ObjectStreamSerializer.throwSerializationException(this.type, e);
        }
        return obj;
    }

    private static void throwUnsupportedEncodingException(Class<?> cls) throws UnsupportedEncodingException {
        throw new UnsupportedEncodingException(String.format("Use %s instead by `fory.registerSerializer(%s, new JavaSerializer(fory, %s))` or implement a custom %s.", JavaSerializer.class, cls, cls, Serializer.class));
    }

    private static void throwSerializationException(Class<?> type, Exception e) {
        throw new RuntimeException(String.format("Serialize object of type %s failed, Try to use %s instead by `fory.registerSerializer(%s, new JavaSerializer(fory, %s))` or implement a custom %s.", type, JavaSerializer.class, type, type, Serializer.class), e);
    }

    private static class ForyObjectInputStream
    extends ObjectInputStream {
        private final Fory fory;
        private final boolean compressInt;
        private final SlotsInfo slotsInfo;
        private MemoryBuffer buffer;
        private Object targetObject;
        private GetFieldImpl getField;
        private boolean fieldsRead;
        private TreeMap<Integer, ObjectInputValidation> callbacks;
        private static final Object NO_VALUE_STUB = new Object();

        protected ForyObjectInputStream(SlotsInfo slotsInfo) throws IOException {
            this.fory = ((SlotsInfo)slotsInfo).slotsSerializer.fory;
            this.compressInt = this.fory.compressInt();
            this.slotsInfo = slotsInfo;
        }

        @Override
        protected Object readObjectOverride() {
            return this.fory.readRef(this.buffer);
        }

        @Override
        public Object readUnshared() {
            return this.fory.readNonRef(this.buffer);
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException {
            if (this.fieldsRead) {
                throw new NotActiveException("not in readObject invocation or fields already read");
            }
            this.slotsInfo.compatibleStreamSerializer.readFields(this.buffer, this.getField.vals);
            this.fieldsRead = true;
            return this.getField;
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            if (this.fieldsRead) {
                throw new NotActiveException("not in readObject invocation or fields already read");
            }
            this.slotsInfo.slotsSerializer.readAndSetFields(this.buffer, this.targetObject);
            this.fieldsRead = true;
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            this.callbacks.put(prio, obj);
        }

        @Override
        public int read() throws IOException {
            return this.buffer.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            if (buf == null) {
                throw new NullPointerException();
            }
            int endOffset = offset + length;
            if (offset < 0 || length < 0 || endOffset > buf.length || endOffset < 0) {
                throw new IndexOutOfBoundsException();
            }
            int remaining = this.buffer.remaining();
            if (remaining > 0 && remaining < length) {
                this.buffer.readBytes(buf, offset, remaining);
                return remaining;
            }
            this.buffer.readBytes(buf, offset, length);
            return length;
        }

        @Override
        public int available() throws IOException {
            return this.buffer.remaining();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buffer.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.buffer.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            byte b = this.buffer.readByte();
            return b & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            return this.buffer.readInt16();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            short b = this.buffer.readInt16();
            return b & 0xFFFF;
        }

        @Override
        public char readChar() throws IOException {
            return this.buffer.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.compressInt ? this.buffer.readVarInt32() : this.buffer.readInt32();
        }

        @Override
        public long readLong() throws IOException {
            return this.fory.readInt64(this.buffer);
        }

        @Override
        public float readFloat() throws IOException {
            return this.buffer.readFloat32();
        }

        @Override
        public double readDouble() throws IOException {
            return this.buffer.readFloat64();
        }

        @Override
        public void readFully(byte[] data) throws IOException {
            this.buffer.readBytes(data);
        }

        @Override
        public void readFully(byte[] data, int offset, int size) throws IOException {
            this.buffer.readBytes(data, offset, size);
        }

        @Override
        public int skipBytes(int len) throws IOException {
            this.buffer.increaseReaderIndex(len);
            return len;
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            return this.fory.readJavaString(this.buffer);
        }

        @Override
        public void close() throws IOException {
        }

        private static class GetFieldImpl
        extends ObjectInputStream.GetField {
            private final SlotsInfo slotsInfo;
            private final Object[] vals;

            GetFieldImpl(SlotsInfo slotsInfo) {
                this.slotsInfo = slotsInfo;
                this.vals = new Object[slotsInfo.putFieldsResolver.getNumFields()];
                Arrays.fill(this.vals, NO_VALUE_STUB);
            }

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                return ObjectStreamClass.lookup(this.slotsInfo.cls);
            }

            @Override
            public boolean defaulted(String name) throws IOException {
                int index = this.slotsInfo.fieldIndexMap.get(name, -1);
                this.checkFieldExists(name, index);
                return this.vals[index] == NO_VALUE_STUB;
            }

            @Override
            public boolean get(String name, boolean val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Boolean)fieldValue;
            }

            @Override
            public byte get(String name, byte val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Byte)fieldValue;
            }

            @Override
            public char get(String name, char val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return ((Character)fieldValue).charValue();
            }

            @Override
            public short get(String name, short val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Short)fieldValue;
            }

            @Override
            public int get(String name, int val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Integer)fieldValue;
            }

            @Override
            public long get(String name, long val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Long)fieldValue;
            }

            @Override
            public float get(String name, float val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return ((Float)fieldValue).floatValue();
            }

            @Override
            public double get(String name, double val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return (Double)fieldValue;
            }

            @Override
            public Object get(String name, Object val) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val;
                }
                return fieldValue;
            }

            private Object getFieldValue(String name) {
                int index = this.slotsInfo.fieldIndexMap.get(name, -1);
                this.checkFieldExists(name, index);
                return this.vals[index];
            }

            private void checkFieldExists(String name, int index) {
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Field name %s not exist in class %s", name, ((SlotsInfo)this.slotsInfo).slotsSerializer.type));
                }
            }
        }
    }

    private static class ForyObjectOutputStream
    extends ObjectOutputStream {
        private final Fory fory;
        private final boolean compressInt;
        private final SlotsInfo slotsInfo;
        private MemoryBuffer buffer;
        private Object targetObject;
        private boolean fieldsWritten;
        private final ObjectArray putFieldsCache = new ObjectArray();
        private PutFieldImpl curPut;

        protected ForyObjectOutputStream(SlotsInfo slotsInfo) throws IOException {
            this.slotsInfo = slotsInfo;
            this.fory = ((SlotsInfo)slotsInfo).slotsSerializer.fory;
            this.compressInt = this.fory.compressInt();
        }

        @Override
        protected final void writeObjectOverride(Object obj) throws IOException {
            this.fory.writeRef(this.buffer, obj);
        }

        @Override
        public void writeUnshared(Object obj) throws IOException {
            this.fory.writeNonRef(this.buffer, obj);
        }

        @Override
        public ObjectOutputStream.PutField putFields() throws IOException {
            if (this.curPut == null) {
                Object o = this.putFieldsCache.popOrNull();
                if (o == null) {
                    o = new PutFieldImpl();
                }
                this.curPut = (PutFieldImpl)o;
            }
            return this.curPut;
        }

        @Override
        public void writeFields() throws IOException {
            if (this.fieldsWritten) {
                throw new NotActiveException("not in writeObject invocation or fields already written");
            }
            PutFieldImpl curPut = this.curPut;
            if (curPut == null) {
                throw new NotActiveException("no current PutField object");
            }
            this.slotsInfo.compatibleStreamSerializer.writeFieldsValues(this.buffer, curPut.vals);
            Arrays.fill(curPut.vals, null);
            this.putFieldsCache.add(curPut);
            this.curPut = null;
            this.fieldsWritten = true;
        }

        @Override
        public void defaultWriteObject() throws IOException, NotActiveException {
            if (this.fieldsWritten) {
                throw new NotActiveException("not in writeObject invocation or fields already written");
            }
            this.slotsInfo.slotsSerializer.write(this.buffer, this.targetObject);
            this.fieldsWritten = true;
        }

        @Override
        public void reset() throws IOException {
            Class cls = this.slotsInfo.slotsSerializer.getType();
            ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            throw new UnsupportedEncodingException();
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            throw new UnsupportedEncodingException();
        }

        @Override
        protected boolean enableReplaceObject(boolean enable) throws SecurityException {
            throw new IllegalStateException();
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.writeByte((byte)b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.buffer.writeBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.writeBytes(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.buffer.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.buffer.writeByte((byte)v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.buffer.writeInt16((short)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.buffer.writeChar((char)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.compressInt) {
                this.buffer.writeVarInt32(v);
            } else {
                this.buffer.writeInt32(v);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.fory.writeInt64(this.buffer, v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.buffer.writeFloat32(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.buffer.writeFloat64(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            Preconditions.checkNotNull(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.buffer.writeByte((byte)s.charAt(i));
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            Preconditions.checkNotNull(s);
            this.fory.writeJavaString(this.buffer, s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            Preconditions.checkNotNull(s);
            this.fory.writeJavaString(this.buffer, s);
        }

        @Override
        public void useProtocolVersion(int version) throws IOException {
            Class cls = this.slotsInfo.cls;
            ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        protected void drain() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        private class PutFieldImpl
        extends ObjectOutputStream.PutField {
            private final Object[] vals;

            PutFieldImpl() {
                this.vals = new Object[ForyObjectOutputStream.this.slotsInfo.putFieldsResolver.getNumFields()];
            }

            private void putValue(String name, Object val) {
                int index = ForyObjectOutputStream.this.slotsInfo.fieldIndexMap.get(name, -1);
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Field name %s not exist in class %s", name, ((SlotsInfo)((ForyObjectOutputStream)ForyObjectOutputStream.this).slotsInfo).slotsSerializer.type));
                }
                this.vals[index] = val;
            }

            @Override
            public void put(String name, boolean val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, byte val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, char val) {
                this.putValue(name, Character.valueOf(val));
            }

            @Override
            public void put(String name, short val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, int val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, long val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, float val) {
                this.putValue(name, Float.valueOf(val));
            }

            @Override
            public void put(String name, double val) {
                this.putValue(name, val);
            }

            @Override
            public void put(String name, Object val) {
                this.putValue(name, val);
            }

            @Override
            @Deprecated
            public void write(ObjectOutput out) throws IOException {
                Class cls = ((SlotsInfo)((ForyObjectOutputStream)ForyObjectOutputStream.this).slotsInfo).slotsSerializer.type;
                ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
            }
        }
    }

    private static class SlotsInfo {
        private final Class<?> cls;
        private final ClassInfo classInfo;
        private final StreamClassInfo streamClassInfo;
        private CompatibleSerializerBase slotsSerializer;
        private final ObjectIntMap<String> fieldIndexMap;
        private final FieldResolver putFieldsResolver;
        private final CompatibleSerializer compatibleStreamSerializer;
        private final ForyObjectOutputStream objectOutputStream;
        private final ForyObjectInputStream objectInputStream;
        private final ObjectArray getFieldPool;

        public SlotsInfo(Fory fory, Class<?> type) {
            this.cls = type;
            this.classInfo = fory.getClassResolver().newClassInfo(type, null, (short)0);
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(type);
            this.streamClassInfo = (StreamClassInfo)STREAM_CLASS_INFO_CACHE.get(type);
            Class sc = CompatibleSerializer.class;
            FieldResolver fieldResolver = FieldResolver.of(fory, type, false, true);
            if (fory.getConfig().isCodeGenEnabled() && CodegenSerializer.supportCodegenForJavaSerialization(this.cls)) {
                sc = fory.getJITContext().registerSerializerJITCallback(() -> CompatibleSerializer.class, () -> CodecUtils.loadOrGenCompatibleCodecClass(this.cls, fory, fieldResolver, Generated.GeneratedCompatibleSerializer.class), c -> {
                    this.slotsSerializer = (CompatibleSerializerBase)Serializers.newSerializer(fory, type, c);
                });
            }
            this.slotsSerializer = sc == CompatibleSerializer.class || GraalvmSupport.isGraalBuildtime() ? new CompatibleSerializer(fory, type, fieldResolver) : (CompatibleSerializerBase)Serializers.newSerializer(fory, type, sc);
            this.fieldIndexMap = new ObjectIntMap(4, 0.4f);
            ArrayList<FieldResolver.ClassField> allFields = new ArrayList<FieldResolver.ClassField>();
            for (ObjectStreamField serialField : objectStreamClass.getFields()) {
                allFields.add(new FieldResolver.ClassField(serialField.getName(), serialField.getType(), this.cls));
            }
            if (this.streamClassInfo.writeObjectMethod != null || this.streamClassInfo.readObjectMethod != null) {
                this.putFieldsResolver = new FieldResolver(fory, this.cls, true, allFields, new HashSet<String>());
                AtomicInteger idx = new AtomicInteger(0);
                for (FieldResolver.FieldInfo fieldInfo : this.putFieldsResolver.getAllFieldsList()) {
                    this.fieldIndexMap.put(fieldInfo.getName(), idx.getAndIncrement());
                }
                this.compatibleStreamSerializer = new CompatibleSerializer(fory, this.cls, this.putFieldsResolver);
            } else {
                this.putFieldsResolver = null;
                this.compatibleStreamSerializer = null;
            }
            if (this.streamClassInfo.writeObjectMethod != null) {
                try {
                    this.objectOutputStream = new ForyObjectOutputStream(this);
                }
                catch (IOException e) {
                    Platform.throwException(e);
                    throw new IllegalStateException("unreachable");
                }
            } else {
                this.objectOutputStream = null;
            }
            if (this.streamClassInfo.readObjectMethod != null) {
                try {
                    this.objectInputStream = new ForyObjectInputStream(this);
                }
                catch (IOException e) {
                    Platform.throwException(e);
                    throw new IllegalStateException("unreachable");
                }
            } else {
                this.objectInputStream = null;
            }
            this.getFieldPool = new ObjectArray();
        }

        public String toString() {
            return "SlotsInfo{cls=" + this.cls + '}';
        }
    }

    private static class StreamClassInfo {
        private final Method writeObjectMethod;
        private final Method readObjectMethod;
        private final Method readObjectNoData;
        private final BiConsumer writeObjectFunc;
        private final BiConsumer readObjectFunc;
        private final Consumer readObjectNoDataFunc;

        private StreamClassInfo(Class<?> type) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(type);
            this.writeObjectMethod = (Method)ReflectionUtils.getObjectFieldValue((Object)objectStreamClass, "writeObjectMethod");
            this.readObjectMethod = (Method)ReflectionUtils.getObjectFieldValue((Object)objectStreamClass, "readObjectMethod");
            this.readObjectNoData = (Method)ReflectionUtils.getObjectFieldValue((Object)objectStreamClass, "readObjectNoData");
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
            BiConsumer writeObjectFunc = null;
            BiConsumer readObjectFunc = null;
            Consumer readObjectNoDataFunc = null;
            try {
                if (this.writeObjectMethod != null) {
                    writeObjectFunc = _JDKAccess.makeJDKBiConsumer(lookup, lookup.unreflect(this.writeObjectMethod));
                }
                if (this.readObjectMethod != null) {
                    readObjectFunc = _JDKAccess.makeJDKBiConsumer(lookup, lookup.unreflect(this.readObjectMethod));
                }
                if (this.readObjectNoData != null) {
                    readObjectNoDataFunc = _JDKAccess.makeJDKConsumer(lookup, lookup.unreflect(this.readObjectNoData));
                }
            }
            catch (Exception e) {
                ExceptionUtils.ignore(e);
            }
            this.writeObjectFunc = writeObjectFunc;
            this.readObjectFunc = readObjectFunc;
            this.readObjectNoDataFunc = readObjectNoDataFunc;
        }
    }
}

