/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.InetAddressValidator;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPUtil {
    public static final boolean PREFER_IPV6_ADDRESSES = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses"));
    public static final String IPV6_START_MARK = "[";
    public static final String IPV6_END_MARK = "]";
    public static final String ILLEGAL_IP_PREFIX = "illegal ip: ";
    public static final String IP_PORT_SPLITER = ":";
    public static final int SPLIT_IP_PORT_RESULT_LENGTH = 2;
    public static final String PERCENT_SIGN_IN_IPV6 = "%";
    private static final String LOCAL_HOST_IP_V4 = "127.0.0.1";
    private static final String LOCAL_HOST_IP_V6 = "[::1]";
    private static final String CHECK_OK = "ok";
    private static final String IPV4_TUPLE = "(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])";
    private static final Pattern IPV4_PATTERN = Pattern.compile("(?<!\\d)(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(?!\\d)");

    public static String localHostIP() {
        if (PREFER_IPV6_ADDRESSES) {
            return LOCAL_HOST_IP_V6;
        }
        return LOCAL_HOST_IP_V4;
    }

    public static boolean isIPv4(String addr) {
        return InetAddressValidator.isIPv4Address(addr);
    }

    public static boolean isIPv6(String addr) {
        return InetAddressValidator.isIPv6Address(IPUtil.removeBrackets(addr));
    }

    public static boolean isIP(String addr) {
        return IPUtil.isIPv4(addr) || IPUtil.isIPv6(addr);
    }

    public static boolean containsPort(String address) {
        return IPUtil.splitIPPortStr(address).length == 2;
    }

    public static String[] splitIPPortStr(String str) {
        String[] serverAddrArr;
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException("ip and port string cannot be empty!");
        }
        if (str.startsWith(IPV6_START_MARK) && StringUtils.containsIgnoreCase(str, IPV6_END_MARK)) {
            serverAddrArr = str.endsWith(IPV6_END_MARK) ? new String[]{str} : new String[]{str.substring(0, str.indexOf(IPV6_END_MARK) + 1), str.substring(str.indexOf(IPV6_END_MARK) + 2)};
            if (!IPUtil.isIPv6(serverAddrArr[0])) {
                throw new IllegalArgumentException("The IPv6 address(\"" + serverAddrArr[0] + "\") is incorrect.");
            }
        } else {
            serverAddrArr = str.split(IP_PORT_SPLITER);
        }
        return serverAddrArr;
    }

    public static String getIPFromString(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        String result = "";
        if (StringUtils.containsIgnoreCase(str, IPV6_START_MARK) && StringUtils.containsIgnoreCase(str, IPV6_END_MARK)) {
            result = str.substring(str.indexOf(IPV6_START_MARK), str.indexOf(IPV6_END_MARK) + 1);
            if (!IPUtil.isIPv6(result)) {
                result = "";
            }
        } else {
            Matcher m = IPV4_PATTERN.matcher(str);
            if (m.find()) {
                result = m.group();
            }
        }
        return result;
    }

    public static String checkIPs(String ... ips) {
        if (ips == null || ips.length == 0) {
            return CHECK_OK;
        }
        StringBuilder illegalResponse = new StringBuilder();
        for (String ip : ips) {
            if (IPUtil.isIP(ip)) continue;
            illegalResponse.append(ip + ",");
        }
        if (illegalResponse.length() == 0) {
            return CHECK_OK;
        }
        return ILLEGAL_IP_PREFIX + illegalResponse.substring(0, illegalResponse.length() - 1);
    }

    public static boolean checkOK(String checkIPsResult) {
        return CHECK_OK.equals(checkIPsResult);
    }

    public static String removeBrackets(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return str.replaceAll("[\\[\\]]", "");
    }
}

