/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class BrokerInfo
implements Comparable<BrokerInfo>,
Serializable {
    private static final long serialVersionUID = -6907854104544421368L;
    private int brokerId;
    private String host;
    private int port;
    private boolean enableTLS = false;
    private int tlsPort = 8124;
    private String addr;
    private String simpleInfo;
    private String fullInfo;
    private String fullTLSInfo;

    public BrokerInfo(String strBrokerInfo) {
        String[] strBrokers = strBrokerInfo.split(":");
        this.brokerId = Integer.parseInt(strBrokers[0]);
        this.host = strBrokers[1];
        this.tlsPort = this.port = Integer.parseInt(strBrokers[2]);
        this.buildStrInfo();
    }

    public BrokerInfo(String strBrokerInfo, int brokerPort) {
        String[] strBrokers = strBrokerInfo.split(":");
        this.brokerId = Integer.parseInt(strBrokers[0]);
        this.host = strBrokers[1];
        this.port = brokerPort;
        if (!TStringUtils.isBlank(strBrokers[2])) {
            this.port = Integer.parseInt(strBrokers[2]);
        }
        this.buildStrInfo();
    }

    public BrokerInfo(int brokerId, String host, int port) {
        this.brokerId = brokerId;
        this.host = host;
        this.port = port;
        this.buildStrInfo();
    }

    public BrokerInfo(int brokerId, String data) {
        this.brokerId = brokerId;
        try {
            URI uri = new URI(data);
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.buildStrInfo();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BrokerInfo(String strBrokerInfo, boolean enableTls, int tlsPort) {
        String[] strBrokers = strBrokerInfo.split(":");
        this.brokerId = Integer.parseInt(strBrokers[0]);
        this.host = strBrokers[1];
        this.port = Integer.parseInt(strBrokers[2]);
        this.enableTLS = enableTls;
        this.tlsPort = tlsPort;
        this.buildStrInfo();
    }

    public BrokerInfo(int brokerId, String host, boolean enableTls, int tlsPort) {
        this.brokerId = brokerId;
        this.host = host;
        this.port = tlsPort;
        this.enableTLS = enableTls;
        this.tlsPort = tlsPort;
        this.buildStrInfo();
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public String getBrokerAddr() {
        return this.addr;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getBrokerStrInfo() {
        return this.fullInfo;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public boolean isEnableTLS() {
        return this.enableTLS;
    }

    public String toString() {
        return this.fullInfo;
    }

    public String getSimpleInfo() {
        if (this.port == 8123) {
            return this.simpleInfo;
        }
        return this.fullInfo;
    }

    public String getFullTLSInfo() {
        return this.fullTLSInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.brokerId;
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrokerInfo other = (BrokerInfo)obj;
        if (!this.host.equals(other.host)) {
            return false;
        }
        if (this.brokerId != other.brokerId) {
            return false;
        }
        return this.port == other.port;
    }

    @Override
    public int compareTo(BrokerInfo o) {
        if (this.brokerId != o.brokerId) {
            return this.brokerId > o.brokerId ? 1 : -1;
        }
        if (!this.host.equals(o.host)) {
            return this.host.compareTo(o.host);
        }
        if (this.port != o.port) {
            return this.port > o.port ? 1 : -1;
        }
        return 0;
    }

    private void buildStrInfo() {
        StringBuilder sBuilder = new StringBuilder(512);
        this.addr = sBuilder.append(this.host).append(":").append(this.port).toString();
        sBuilder.delete(0, sBuilder.length());
        this.simpleInfo = sBuilder.append(this.brokerId).append(":").append(this.host).append(":").append(" ").toString();
        sBuilder.delete(0, sBuilder.length());
        this.fullInfo = sBuilder.append(this.brokerId).append(":").append(this.host).append(":").append(this.port).toString();
        sBuilder.delete(0, sBuilder.length());
        this.fullTLSInfo = sBuilder.append(this.brokerId).append(":").append(this.host).append(":").append(this.tlsPort).toString();
    }
}

