/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;

public class SubscribeInfo {
    private String consumerId;
    private String group;
    private Partition partition;
    private boolean overTLS = false;
    private String fullInfo;

    public SubscribeInfo(String strSubInfo) {
        String strConsumerInfo = strSubInfo.split("#")[0];
        String strBrokerInfo = strSubInfo.split("#")[1];
        String strPartInfo = strSubInfo.split("#")[2];
        this.consumerId = strConsumerInfo.split("@")[0];
        this.group = strConsumerInfo.split("@")[1];
        this.partition = new Partition(new BrokerInfo(strBrokerInfo), strPartInfo);
        this.builderSubscribeStr();
    }

    public SubscribeInfo(String consumerId, String group, Partition partition) {
        this.consumerId = consumerId;
        this.group = group;
        this.partition = partition;
        this.builderSubscribeStr();
    }

    public SubscribeInfo(String consumerId, String group, boolean overTLS, Partition partition) {
        this.consumerId = consumerId;
        this.group = group;
        this.partition = partition;
        this.overTLS = overTLS;
        this.builderSubscribeStr();
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
        if (this.group != null && this.partition != null) {
            this.builderSubscribeStr();
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        if (this.group != null && this.partition != null) {
            this.builderSubscribeStr();
        }
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
        if (this.group != null && this.partition != null) {
            this.builderSubscribeStr();
        }
    }

    public String getPartitionStr() {
        return this.partition.getPartitionFullStr(this.overTLS);
    }

    public int getBrokerId() {
        return this.partition.getBrokerId();
    }

    public String getHost() {
        return this.partition.getHost();
    }

    public int getPort() {
        return this.partition.getPort();
    }

    public String getTopic() {
        return this.partition.getTopic();
    }

    public int getPartitionId() {
        return this.partition.getPartitionId();
    }

    private void builderSubscribeStr() {
        StringBuilder sBuilder = new StringBuilder(256);
        this.fullInfo = sBuilder.append(this.consumerId).append("@").append(this.group).append("#").append(this.partition.getPartitionFullStr(this.overTLS)).toString();
    }

    public String toString() {
        return this.fullInfo;
    }
}

