/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public class TopicInfo
implements Serializable {
    private static final long serialVersionUID = -2394664452604382172L;
    private BrokerInfo broker;
    private String topic;
    private String simpleTopicInfo;
    private String simpleValue;
    private int partitionNum;
    private int topicStoreNum = 1;
    private boolean acceptPublish;
    private boolean acceptSubscribe;

    public TopicInfo(BrokerInfo broker, String topic, int partitionNum, int topicStoreNum, boolean acceptPublish, boolean acceptSubscribe) {
        this.broker = broker;
        this.topic = topic;
        this.partitionNum = partitionNum;
        this.topicStoreNum = topicStoreNum;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.builderTopicStr();
    }

    public BrokerInfo getBroker() {
        return this.broker;
    }

    public int getBrokerId() {
        return this.broker.getBrokerId();
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public void setAcceptPublish(boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setAcceptSubscribe(boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public void updAndJudgeTopicInfo(TopicInfo newTopicInfo, Tuple2<Boolean, Boolean> result) {
        boolean isChanged = false;
        if (this.acceptPublish != newTopicInfo.acceptPublish) {
            isChanged = true;
            this.acceptPublish = newTopicInfo.acceptPublish;
        }
        if (this.acceptSubscribe != newTopicInfo.acceptSubscribe) {
            isChanged = true;
            this.acceptSubscribe = newTopicInfo.acceptSubscribe;
        }
        result.setF0AndF1(isChanged, this.partitionNum != newTopicInfo.partitionNum || this.topicStoreNum != newTopicInfo.topicStoreNum);
    }

    public int getTopicStoreNum() {
        return this.topicStoreNum;
    }

    public String getSimpleValue() {
        return this.simpleValue;
    }

    public StringBuilder toStrBuilderString(StringBuilder sBuilder) {
        return sBuilder.append(this.broker.toString()).append("#").append(this.topic).append(":").append(this.partitionNum).append(":").append(this.acceptPublish).append(":").append(this.acceptSubscribe).append(":").append(this.topicStoreNum);
    }

    public StringBuilder toStrBuilderString(boolean acceptPub, boolean acceptSub, StringBuilder sBuilder) {
        return sBuilder.append(this.broker.toString()).append("#").append(this.topic).append(":").append(this.partitionNum).append(":").append(acceptPub && this.acceptPublish).append(":").append(acceptSub && this.acceptSubscribe).append(":").append(this.topicStoreNum);
    }

    public String toString() {
        return this.toStrBuilderString(new StringBuilder(512)).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicInfo other = (TopicInfo)obj;
        if (this.broker.getBrokerId() != other.broker.getBrokerId()) {
            return false;
        }
        if (!this.broker.getHost().equals(other.broker.getHost())) {
            return false;
        }
        if (!this.topic.equals(other.topic)) {
            return false;
        }
        if (this.partitionNum != other.partitionNum) {
            return false;
        }
        if (this.acceptPublish != other.acceptPublish) {
            return false;
        }
        return this.acceptSubscribe == other.acceptSubscribe;
    }

    public int hashCode() {
        int result = this.broker != null ? this.broker.hashCode() : 0;
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.simpleTopicInfo != null ? this.simpleTopicInfo.hashCode() : 0);
        result = 31 * result + (this.simpleValue != null ? this.simpleValue.hashCode() : 0);
        result = 31 * result + this.partitionNum;
        result = 31 * result + this.topicStoreNum;
        result = 31 * result + (this.acceptPublish ? 1 : 0);
        result = 31 * result + (this.acceptSubscribe ? 1 : 0);
        return result;
    }

    public TopicInfo clone() {
        return new TopicInfo(this.broker, this.topic, this.partitionNum, this.topicStoreNum, this.acceptPublish, this.acceptSubscribe);
    }

    private void builderTopicStr() {
        StringBuilder sBuilder = new StringBuilder(256);
        this.simpleTopicInfo = sBuilder.append(this.broker.getBrokerId()).append("#").append(this.topic).append(":").append(this.partitionNum).append(":").append(this.topicStoreNum).toString();
        sBuilder.delete(0, sBuilder.length());
        this.simpleValue = sBuilder.append(this.broker.getBrokerId()).append(":").append(this.partitionNum).append(":").append(this.topicStoreNum).toString();
    }
}

