/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.SinkInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MapSinkInfo
extends SinkInfo {
    private List<FieldInfo> fields;

    public MapSinkInfo(@JsonProperty(value="charset") String charset, @JsonProperty(value="fields") List<FieldInfo> fields) {
        super("es_map", charset);
        if (CollectionUtils.isEmpty(fields)) {
            throw new IllegalArgumentException("failed to init map sink info, fieldInfos is empty");
        }
        this.fields = fields;
    }

    protected MapSinkInfo(MapSinkInfoBuilder<?, ?> b) {
        super(b);
        this.fields = ((MapSinkInfoBuilder)b).fields;
    }

    public static MapSinkInfoBuilder<?, ?> builder() {
        return new MapSinkInfoBuilderImpl();
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapSinkInfo)) {
            return false;
        }
        MapSinkInfo other = (MapSinkInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldInfo> this$fields = this.getFields();
        List<FieldInfo> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MapSinkInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldInfo> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MapSinkInfo(fields=" + this.getFields() + ")";
    }

    private static final class MapSinkInfoBuilderImpl
    extends MapSinkInfoBuilder<MapSinkInfo, MapSinkInfoBuilderImpl> {
        private MapSinkInfoBuilderImpl() {
        }

        @Override
        protected MapSinkInfoBuilderImpl self() {
            return this;
        }

        @Override
        public MapSinkInfo build() {
            return new MapSinkInfo(this);
        }
    }

    public static abstract class MapSinkInfoBuilder<C extends MapSinkInfo, B extends MapSinkInfoBuilder<C, B>>
    extends SinkInfo.SinkInfoBuilder<C, B> {
        private List<FieldInfo> fields;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fields(List<FieldInfo> fields) {
            this.fields = fields;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MapSinkInfo.MapSinkInfoBuilder(super=" + super.toString() + ", fields=" + this.fields + ")";
        }
    }
}

